/*
 * Decompiled with CFR 0.152.
 */
package fr.minecraftforgefrance.installer;

import argo.jdom.JsonField;
import argo.jdom.JsonRootNode;
import fr.minecraftforgefrance.common.EnumOS;
import fr.minecraftforgefrance.common.Localization;
import fr.minecraftforgefrance.common.RemoteInfoReader;
import fr.minecraftforgefrance.installer.Installer;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class OptionFrame
extends JDialog {
    private static final long serialVersionUID = 1L;
    public JLabel modpackFolder;
    public JLabel infoLabel;
    private JTextField selectedDirText;

    public OptionFrame(Frame parent) {
        this.setTitle(Localization.LANG.getTranslation("title.options"));
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 3));
        JLabel gameFolder = new JLabel(Localization.LANG.getTranslation("option.mcDir.info"));
        gameFolder.setAlignmentX(0.5f);
        mainPanel.add(gameFolder);
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 0));
        this.selectedDirText = new JTextField();
        this.selectedDirText.setEditable(false);
        this.selectedDirText.setColumns(35);
        panel1.add(this.selectedDirText);
        JButton dirSelect = new JButton();
        dirSelect.setAction(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser dirChooser = new JFileChooser();
                dirChooser.setFileSelectionMode(1);
                dirChooser.setFileHidingEnabled(false);
                dirChooser.ensureFileIsVisible(EnumOS.getMinecraftDefaultDir());
                dirChooser.setSelectedFile(EnumOS.getMinecraftDefaultDir());
                int response = dirChooser.showOpenDialog(OptionFrame.this);
                switch (response) {
                    case 0: {
                        try {
                            OptionFrame.this.updateMinecraftDir(dirChooser.getSelectedFile().getCanonicalFile());
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        break;
                    }
                }
            }
        });
        dirSelect.setText("...");
        dirSelect.setToolTipText(Localization.LANG.getTranslation("option.mcDir.select"));
        panel1.add(dirSelect);
        panel1.setAlignmentY(0.0f);
        mainPanel.add(panel1);
        this.infoLabel = new JLabel();
        this.infoLabel.setForeground(Color.RED);
        this.infoLabel.setVisible(false);
        this.infoLabel.setAlignmentX(0.5f);
        mainPanel.add(this.infoLabel);
        JLabel label = new JLabel(Localization.LANG.getTranslation("option.modpackDir.info"));
        label.setAlignmentX(0.5f);
        label.setAlignmentY(0.0f);
        mainPanel.add(label);
        this.modpackFolder = new JLabel();
        this.modpackFolder.setAlignmentX(0.5f);
        this.modpackFolder.setAlignmentY(1.0f);
        mainPanel.add(this.modpackFolder);
        if (RemoteInfoReader.instance().hasPreset()) {
            try {
                JsonRootNode json = RemoteInfoReader.instance().getPreset();
                JPanel choicePanel = new JPanel();
                JLabel preConfig = new JLabel(Localization.LANG.getTranslation("option.preset"));
                choicePanel.add(preConfig);
                ButtonGroup choiceButtonGroup = new ButtonGroup();
                for (JsonField field : json.getFieldList()) {
                    String presetName = field.getName().getText();
                    if (presetName.equals("default")) continue;
                    JRadioButton button = new JRadioButton(presetName);
                    class PreSetAction
                    extends AbstractAction {
                        private static final long serialVersionUID = 1L;
                        private final String name;

                        public PreSetAction(String name) {
                            this.name = name;
                        }

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Installer.frame.preSet = this.name;
                        }
                    }
                    button.setAction(new PreSetAction(presetName));
                    button.setText(presetName);
                    button.setSelected(presetName.equals(Installer.frame.preSet));
                    button.setAlignmentX(0.0f);
                    button.setAlignmentY(0.5f);
                    choiceButtonGroup.add(button);
                    choicePanel.add(button);
                }
                choicePanel.setAlignmentY(0.5f);
                mainPanel.add(choicePanel);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        JPanel buttonPanel = new JPanel();
        JButton confirm = new JButton(Localization.LANG.getTranslation("option.confirm"));
        confirm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionFrame.this.dispose();
            }
        });
        buttonPanel.add(confirm);
        mainPanel.add(buttonPanel);
        this.add(mainPanel);
        this.pack();
        this.setLocationRelativeTo(parent);
        this.updateMinecraftDir(EnumOS.getMinecraftDefaultDir());
    }

    public void updateMinecraftDir(File newMCDir) {
        this.selectedDirText.setText(newMCDir.getPath());
        this.modpackFolder.setText(newMCDir.getPath() + File.separator + "modpack" + File.separator + RemoteInfoReader.instance().getModPackName());
        File launcherProfiles = new File(newMCDir, "launcher_profiles.json");
        if (!launcherProfiles.exists()) {
            this.infoLabel.setText(Localization.LANG.getTranslation("option.folder.notValid"));
            this.infoLabel.setVisible(true);
        } else {
            Installer.frame.mcDir = newMCDir;
            this.infoLabel.setVisible(false);
        }
        this.pack();
    }
}

