/*
 * Decompiled with CFR 0.152.
 */
package fr.minecraftforgefrance.common;

import argo.format.JsonFormatter;
import argo.format.PrettyJsonFormatter;
import argo.jdom.JdomParser;
import argo.jdom.JsonField;
import argo.jdom.JsonNode;
import argo.jdom.JsonNodeBuilders;
import argo.jdom.JsonNodeFactories;
import argo.jdom.JsonNodeSelector;
import argo.jdom.JsonNodeSelectors;
import argo.jdom.JsonObjectNodeBuilder;
import argo.jdom.JsonRootNode;
import argo.jdom.JsonStringNode;
import argo.saj.InvalidSyntaxException;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import fr.minecraftforgefrance.common.DownloadUtils;
import fr.minecraftforgefrance.common.FileChecker;
import fr.minecraftforgefrance.common.FileEntry;
import fr.minecraftforgefrance.common.IInstallRunner;
import fr.minecraftforgefrance.common.InstallFrame;
import fr.minecraftforgefrance.common.LibEntry;
import fr.minecraftforgefrance.common.Localization;
import fr.minecraftforgefrance.common.Logger;
import fr.minecraftforgefrance.common.RemoteInfoReader;
import java.awt.EventQueue;
import java.awt.HeadlessException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;

public class ProcessInstall
implements Runnable {
    private final InstallFrame installFrame;
    private List<LibEntry> missingLibs = new ArrayList<LibEntry>();
    private static final JsonFormatter JSON_FORMATTER = new PrettyJsonFormatter();
    private final FileChecker fileChecker;
    private final IInstallRunner runner;
    private final String preset;
    public final File mcDir;
    public final File modPackDir;
    private boolean error = false;

    public ProcessInstall(FileChecker file, IInstallRunner runner, File mcDir, String preset) {
        this.installFrame = new InstallFrame(this);
        this.fileChecker = file;
        this.runner = runner;
        this.mcDir = mcDir;
        this.modPackDir = new File(new File(mcDir, "modpacks"), RemoteInfoReader.instance().getModPackName());
        this.preset = preset;
    }

    public void createFrame() {
        this.installFrame.run();
    }

    @Override
    public void run() {
        if (this.fileChecker.remoteList.isEmpty()) {
            this.installFrame.dispose();
            JOptionPane.showMessageDialog(null, Localization.LANG.getTranslation("err.noFile"), Localization.LANG.getTranslation("misc.error"), 0);
            return;
        }
        this.deleteDeprecated();
        final int totalSize = this.getTotalDownloadSize();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((ProcessInstall)ProcessInstall.this).installFrame.fullProgressBar.setMaximum(totalSize);
                ((ProcessInstall)ProcessInstall.this).installFrame.fullProgressBar.setIndeterminate(false);
            }
        });
        this.downloadMod();
        if (this.runner.shouldDownloadLib()) {
            this.downloadLib();
        }
        if (this.preset != null) {
            this.downloadPreset();
        }
        if (!this.error) {
            this.finish();
        }
    }

    public void deleteDeprecated() {
        for (FileEntry entry : this.fileChecker.outdatedList) {
            File f = new File(this.modPackDir, entry.getPath());
            if (f.delete()) {
                Logger.info(String.format("%1$s was removed. Its md5 was : %2$s", f.getPath(), entry.getMd5()));
                continue;
            }
            this.installFrame.dispose();
            JOptionPane.showMessageDialog(null, Localization.LANG.getTranslation("err.cannotdeletefile") + " : " + f.getPath(), "Error", 0);
        }
    }

    private int checkMissingLibs() {
        File librariesDir = new File(this.mcDir, "libraries");
        final List<JsonNode> libraries = RemoteInfoReader.instance().getProfileInfo().getArrayNode("libraries");
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((ProcessInstall)ProcessInstall.this).installFrame.fileProgressBar.setMaximum(libraries.size());
                ((ProcessInstall)ProcessInstall.this).installFrame.fileProgressBar.setIndeterminate(false);
            }
        });
        int max = 0;
        for (JsonNode library : libraries) {
            this.changeCurrentDownloadText(library.getStringValue("name"));
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((ProcessInstall)ProcessInstall.this).installFrame.fileProgressBar.setValue(((ProcessInstall)ProcessInstall.this).installFrame.fileProgressBar.getValue() + 1);
                }
            });
            ArrayList<String> checksums = null;
            String libName = library.getStringValue("name");
            if (!library.isBooleanValue("required") || !library.getBooleanValue("required").booleanValue()) continue;
            if (library.isArrayNode("checksums")) {
                checksums = Lists.newArrayList(Lists.transform(library.getArrayNode("checksums"), new Function<JsonNode, String>(){

                    @Override
                    public String apply(JsonNode node) {
                        return node.getText();
                    }
                }));
            }
            Logger.info(String.format("Considering library %s", libName));
            String[] nameparts = Iterables.toArray(Splitter.on(':').split(libName), String.class);
            nameparts[0] = nameparts[0].replace('.', '/');
            String jarName = nameparts[1] + '-' + nameparts[2] + ".jar";
            String pathName = nameparts[0] + '/' + nameparts[1] + '/' + nameparts[2] + '/' + jarName;
            File libPath = new File(librariesDir, pathName.replace('/', File.separatorChar));
            String libURL = "https://libraries.minecraft.net/";
            if (library.isStringValue("url")) {
                libURL = library.getStringValue("url") + (!library.getStringValue("url").endsWith("/") ? "/" : "");
            }
            if (libPath.exists() && DownloadUtils.checksumValid(libPath, checksums)) continue;
            libPath.getParentFile().mkdirs();
            libURL = libURL + pathName;
            File pack = null;
            boolean xz = false;
            if (library.isBooleanValue("xz") && library.getBooleanValue("xz").booleanValue()) {
                xz = true;
                pack = new File(libPath.getParentFile(), libPath.getName() + ".pack.xz");
                libURL = libURL + ".pack.xz";
            }
            if (library.isStringValue("directURL")) {
                libURL = library.getStringValue("directURL");
            }
            try {
                URL url = new URL(libURL);
                URLConnection connection = url.openConnection();
                connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:10.0) Gecko/20100101 Firefox/55.0");
                int fileLength = connection.getContentLength();
                max += fileLength;
                this.missingLibs.add(new LibEntry(libURL, libName, libPath, pack, fileLength, xz));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return max;
    }

    private int getTotalDownloadSize() {
        int size = 0;
        for (FileEntry entry : this.fileChecker.missingList) {
            size = (int)((long)size + entry.getSize());
        }
        if (this.runner.shouldDownloadLib()) {
            size += this.checkMissingLibs();
        }
        return size;
    }

    public void downloadMod() {
        this.installFrame.setTitle(Localization.LANG.getTranslation("proc.downloadingmods"));
        for (FileEntry entry : this.fileChecker.missingList) {
            File f = new File(this.modPackDir, entry.getPath());
            if (f.getParentFile() != null && !f.getParentFile().isDirectory()) {
                f.getParentFile().mkdirs();
            }
            this.changeCurrentDownloadText(entry.getPath());
            Logger.info(String.format("Downloading file %1$s to %2$s (its md5 is %3$s)", entry.getUrl().toString(), f.getPath(), entry.getMd5()));
            if (DownloadUtils.downloadFile(entry.getUrl(), f, this.installFrame)) continue;
            this.installFrame.dispose();
            JOptionPane.showMessageDialog(null, Localization.LANG.getTranslation("err.cannotdownload") + " : " + entry.getUrl().toString(), Localization.LANG.getTranslation("misc.error"), 0);
            Thread.currentThread().interrupt();
            this.error = true;
            return;
        }
    }

    public void downloadLib() {
        this.installFrame.setTitle(Localization.LANG.getTranslation("title.libs"));
        for (LibEntry entry : this.missingLibs) {
            this.changeCurrentDownloadText(String.format(Localization.LANG.getTranslation("proc.downloadinglib"), entry.getName()));
            try {
                File filePath;
                File file = filePath = entry.isXZ() ? entry.getPackDest() : entry.getDest();
                if (!DownloadUtils.downloadFile(new URL(entry.getUrl()), filePath, this.installFrame)) {
                    this.installFrame.dispose();
                    JOptionPane.showMessageDialog(null, Localization.LANG.getTranslation("err.cannotdownload") + " : " + entry.getUrl().toString() + (entry.isXZ() ? ".pack.xz" : ""), Localization.LANG.getTranslation("misc.error"), 0);
                    Thread.currentThread().interrupt();
                    this.error = true;
                    return;
                }
                if (!entry.isXZ()) continue;
                try {
                    this.changeCurrentDownloadText(Localization.LANG.getTranslation("proc.unpackingfile") + " : " + entry.getPackDest().toString());
                    DownloadUtils.unpackLibrary(entry.getDest(), Files.toByteArray(entry.getPackDest()));
                    this.changeCurrentDownloadText(String.format(Localization.LANG.getTranslation("file.unpacked.success"), entry.getPackDest().toString()));
                    entry.getPackDest().delete();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (HeadlessException e) {
                e.printStackTrace();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    public void downloadPreset() {
        this.installFrame.setTitle(Localization.LANG.getTranslation("title.preset"));
        final JsonRootNode data = RemoteInfoReader.instance().getPreset();
        final JsonNodeSelector<JsonNode, List<JsonNode>> preSet = JsonNodeSelectors.anArrayNode(this.preset);
        final JsonNodeSelector<JsonNode, String> preSetName = JsonNodeSelectors.aStringNode(new Object[0]);
        AbstractList<String> files = new AbstractList<String>(){

            @Override
            public String get(int index) {
                return (String)preSetName.getValue(((List)preSet.getValue(data)).get(index));
            }

            @Override
            public int size() {
                return ((List)preSet.getValue(data)).size();
            }
        };
        for (String file : files) {
            File destFile = new File(this.modPackDir, file);
            if (destFile.exists()) continue;
            if (!destFile.getParentFile().exists()) {
                destFile.getParentFile().mkdirs();
            }
            this.changeCurrentDownloadText(file);
            try {
                if (DownloadUtils.downloadFile(new URL(RemoteInfoReader.instance().getPresetUrl() + this.preset + "/" + DownloadUtils.escapeURIPathParam(file)), destFile, this.installFrame)) continue;
                this.installFrame.dispose();
                JOptionPane.showMessageDialog(null, Localization.LANG.getTranslation("err.cannotdownload") + " : " + RemoteInfoReader.instance().getPresetUrl() + this.preset + "/" + DownloadUtils.escapeURIPathParam(file), Localization.LANG.getTranslation("misc.error"), 0);
                Thread.currentThread().interrupt();
                this.error = true;
                return;
            }
            catch (HeadlessException e) {
                e.printStackTrace();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    private void changeCurrentDownloadText(final String text) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((ProcessInstall)ProcessInstall.this).installFrame.currentDownload.setText(text);
            }
        });
    }

    public void finish() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((ProcessInstall)ProcessInstall.this).installFrame.fullProgressBar.setMaximum(100);
                ((ProcessInstall)ProcessInstall.this).installFrame.fullProgressBar.setValue(100);
            }
        });
        this.installFrame.setTitle(Localization.LANG.getTranslation("misc.finishing"));
        this.createOrUpdateProfile();
        this.writeModPackInfo();
        this.addToProfileList();
        this.installFrame.dispose();
        this.runner.onFinish();
    }

    private void createOrUpdateProfile() {
        File versionRootDir = new File(this.mcDir, "versions");
        String modpackName = RemoteInfoReader.instance().getModPackName();
        File modpackVersionDir = new File(versionRootDir, modpackName);
        if (!modpackVersionDir.exists()) {
            modpackVersionDir.mkdirs();
        }
        File modpackJson = new File(modpackVersionDir, modpackName + ".json");
        JsonRootNode versionJson = JsonNodeFactories.object(RemoteInfoReader.instance().getProfileInfo().getFields());
        try {
            BufferedWriter newWriter = Files.newWriter(modpackJson, Charsets.UTF_8);
            JSON_FORMATTER.format(versionJson, newWriter);
            newWriter.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, Localization.LANG.getTranslation("err.cannotwriteversion"), Localization.LANG.getTranslation("misc.error"), 0);
        }
    }

    private boolean isProfileValid(JsonRootNode profiles, String modpackName, String displayName) {
        if (profiles.isObjectNode("profiles", displayName) && profiles.isStringValue("profiles", displayName, "name") && profiles.getStringValue("profiles", displayName, "name").equals(displayName)) {
            return profiles.getStringValue("profiles", displayName, "lastVersionId").equals(modpackName);
        }
        return false;
    }

    private void addToProfileList() {
        JsonRootNode jsonProfileData;
        String modpackName = RemoteInfoReader.instance().getModPackName();
        String displayName = RemoteInfoReader.instance().getModPackDisplayName();
        File launcherProfiles = new File(this.mcDir, "launcher_profiles.json");
        JdomParser parser = new JdomParser();
        if (!launcherProfiles.exists()) {
            JOptionPane.showMessageDialog(null, Localization.LANG.getTranslation("err.mcprofilemissing"), Localization.LANG.getTranslation("misc.error"), 0);
            this.installFrame.dispose();
            return;
        }
        try {
            jsonProfileData = parser.parse(Files.newReader(launcherProfiles, Charsets.UTF_8));
        }
        catch (InvalidSyntaxException e) {
            JOptionPane.showMessageDialog(null, Localization.LANG.getTranslation("err.mcprofilecorrupted"), Localization.LANG.getTranslation("misc.error"), 0);
            throw Throwables.propagate(e);
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
        if (!this.isProfileValid(jsonProfileData, modpackName, displayName)) {
            JsonField[] fields = new JsonField[RemoteInfoReader.instance().hasArgument() ? 5 : 4];
            fields[0] = JsonNodeFactories.field("name", (JsonNode)JsonNodeFactories.string(displayName));
            fields[1] = JsonNodeFactories.field("lastVersionId", (JsonNode)JsonNodeFactories.string(modpackName));
            fields[2] = JsonNodeFactories.field("type", (JsonNode)JsonNodeFactories.string("custom"));
            fields[3] = JsonNodeFactories.field("gameDir", (JsonNode)JsonNodeFactories.string(this.modPackDir.getAbsoluteFile().toString()));
            if (RemoteInfoReader.instance().hasArgument()) {
                fields[4] = JsonNodeFactories.field("javaArgs", (JsonNode)JsonNodeFactories.string(RemoteInfoReader.instance().getArgument()));
            }
            HashMap<JsonStringNode, JsonNode> profileCopy = Maps.newHashMap(jsonProfileData.getNode("profiles").getFields());
            HashMap<JsonStringNode, JsonNode> rootCopy = Maps.newHashMap(jsonProfileData.getFields());
            profileCopy.put(JsonNodeFactories.string(displayName), JsonNodeFactories.object(fields));
            JsonRootNode profileJsonCopy = JsonNodeFactories.object(profileCopy);
            rootCopy.put(JsonNodeFactories.string("profiles"), profileJsonCopy);
            jsonProfileData = JsonNodeFactories.object(rootCopy);
            try {
                BufferedWriter newWriter = Files.newWriter(launcherProfiles, Charsets.UTF_8);
                JSON_FORMATTER.format(jsonProfileData, newWriter);
                newWriter.close();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, Localization.LANG.getTranslation("err.cannotwriteprofile"), Localization.LANG.getTranslation("misc.error"), 0);
            }
        }
    }

    public void writeModPackInfo() {
        JsonRootNode changeLog;
        File info = new File(this.modPackDir, RemoteInfoReader.instance().getModPackName() + ".json");
        if (!info.exists()) {
            try {
                info.createNewFile();
            }
            catch (IOException e) {
                throw Throwables.propagate(e);
            }
        }
        JsonObjectNodeBuilder jsonBuilder = JsonNodeBuilders.anObjectBuilder().withField("forge", JsonNodeBuilders.aStringBuilder(RemoteInfoReader.instance().getForgeVersion()));
        jsonBuilder.withField("remote", JsonNodeBuilders.aStringBuilder(RemoteInfoReader.instance().remoteUrl));
        if (RemoteInfoReader.instance().hasChangeLog() && (changeLog = RemoteInfoReader.instance().getChangeLog()) != null && changeLog.hasFields()) {
            jsonBuilder.withField("currentVersion", JsonNodeBuilders.aStringBuilder(changeLog.getFieldList().get(0).getName().getText()));
        }
        JsonRootNode json = jsonBuilder.build();
        try {
            BufferedWriter writer = Files.newWriter(info, Charsets.UTF_8);
            JSON_FORMATTER.format(json, writer);
            writer.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, Localization.LANG.getTranslation("err.cannotwriteversion"), Localization.LANG.getTranslation("misc.error"), 0);
        }
    }
}

