/*
 * Decompiled with CFR 0.152.
 */
package fr.minecraftforgefrance.common;

import argo.jdom.JdomParser;
import argo.jdom.JsonNode;
import argo.jdom.JsonRootNode;
import argo.saj.InvalidSyntaxException;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import fr.minecraftforgefrance.common.Localization;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import javax.swing.JOptionPane;

public class RemoteInfoReader {
    public static RemoteInfoReader instance;
    public JsonRootNode data;
    public final String remoteUrl;
    private final JdomParser parser = new JdomParser();

    public RemoteInfoReader(String url) {
        this.remoteUrl = url;
    }

    public boolean init() {
        try {
            InputStreamReader reader = this.getRemoteStream(this.remoteUrl);
            this.data = this.parser.parse(reader);
            return true;
        }
        catch (InvalidSyntaxException e) {
            JOptionPane.showMessageDialog(null, Localization.LANG.getTranslation("err.jsoninvalid"), Localization.LANG.getTranslation("misc.error"), 0);
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, Localization.LANG.getTranslation("err.cannotreadremote"), Localization.LANG.getTranslation("misc.error"), 0);
            e.printStackTrace();
            return false;
        }
        catch (URISyntaxException e) {
            JOptionPane.showMessageDialog(null, Localization.LANG.getTranslation("err.cannotreadremote"), Localization.LANG.getTranslation("misc.error"), 0);
            e.printStackTrace();
            return false;
        }
    }

    public static RemoteInfoReader instance() {
        return instance;
    }

    public String getModPackName() {
        return this.data.getStringValue("profile", "id");
    }

    public String getModPackDisplayName() {
        return this.data.getStringValue("install", "name");
    }

    public String getMinecraftVersion() {
        return this.data.getStringValue("install", "minecraft");
    }

    public String getForgeVersion() {
        return this.data.getStringValue("install", "forge");
    }

    public boolean enableSubFolder() {
        return this.data.isBooleanValue("install", "subfolder") && this.data.getBooleanValue("install", "subfolder") != false;
    }

    public ArrayList<String> getSyncDir() {
        return Lists.newArrayList(Splitter.on(',').trimResults().omitEmptyStrings().split(this.data.getStringValue("install", "syncDir")));
    }

    public String getSyncUrl() {
        return this.data.getStringValue("install", "syncUrl");
    }

    public String getVersionTarget() {
        return this.data.getStringValue("install", "target");
    }

    public JsonNode getProfileInfo() {
        return this.data.getNode("profile");
    }

    public String getWelcome() {
        return this.data.getStringValue("install", "welcome");
    }

    public boolean hasArgument() {
        return this.data.isStringValue("install", "JVMarg");
    }

    public String getArgument() {
        return this.data.getStringValue("install", "JVMarg");
    }

    public boolean hasWhiteList() {
        return this.data.isStringValue("install", "whiteList");
    }

    public JsonRootNode getWhileList() {
        try {
            InputStreamReader reader = this.getRemoteStream(this.data.getStringValue("install", "whiteList"));
            return this.parser.parse(reader);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean hasWebSite() {
        return this.data.isStringValue("install", "webSite");
    }

    public String getWebSite() {
        return this.data.getStringValue("install", "webSite");
    }

    public boolean hasCredits() {
        return this.data.isStringValue("install", "credits");
    }

    public String getCredits() {
        return this.data.getStringValue("install", "credits");
    }

    public boolean hasChangeLog() {
        return this.data.isStringValue("install", "changeLog");
    }

    public JsonRootNode getChangeLog() {
        try {
            InputStreamReader reader = this.getRemoteStream(this.data.getStringValue("install", "changeLog"));
            return this.parser.parse(reader);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean hasPreset() {
        return this.data.isStringValue("install", "preset");
    }

    public JsonRootNode getPreset() {
        try {
            InputStreamReader reader = this.getRemoteStream(this.data.getStringValue("install", "preset"));
            return this.parser.parse(reader);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getPresetUrl() {
        return this.data.getStringValue("install", "preset");
    }

    private InputStreamReader getRemoteStream(String str) throws MalformedURLException, IOException, URISyntaxException {
        URI uri = new URI(str);
        URLConnection connection = uri.toURL().openConnection();
        connection.setRequestProperty("Accept-Encoding", "gzip");
        connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:10.0) Gecko/20100101 Firefox/55.0");
        InputStreamReader reader = null;
        reader = "gzip".equals(connection.getContentEncoding()) ? new InputStreamReader((InputStream)new GZIPInputStream(connection.getInputStream()), Charsets.UTF_8) : new InputStreamReader(connection.getInputStream(), Charsets.UTF_8);
        return reader;
    }
}

