/*
 * Decompiled with CFR 0.152.
 */
package fr.minecraftforgefrance.common;

import argo.jdom.JsonField;
import fr.minecraftforgefrance.common.DownloadUtils;
import fr.minecraftforgefrance.common.FileEntry;
import fr.minecraftforgefrance.common.RemoteInfoReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FileChecker {
    public List<FileEntry> remoteList = Collections.synchronizedList(new ArrayList());
    public List<FileEntry> syncList = new ArrayList<FileEntry>();
    public List<String> checkDir = new ArrayList<String>();
    public List<FileEntry> localList = new ArrayList<FileEntry>();
    public List<FileEntry> missingList;
    public List<FileEntry> outdatedList;
    private final File modPackDir;

    public FileChecker(File modpackDir) {
        this.modPackDir = modpackDir;
        DownloadUtils.readRemoteList(this.remoteList, this.checkDir);
        this.getLocalFile();
        this.compare();
    }

    private void getLocalFile() {
        if (!this.modPackDir.isDirectory()) {
            this.modPackDir.delete();
        }
        if (!this.modPackDir.exists()) {
            this.modPackDir.mkdirs();
            return;
        }
        for (String dirName : this.checkDir) {
            File dir = new File(this.modPackDir, dirName);
            if (!dir.exists() || !dir.isDirectory()) continue;
            if (RemoteInfoReader.instance().getSyncDir().contains(dirName)) {
                this.addFiles(this.localList, this.syncList, dir, this.modPackDir.getAbsolutePath(), true);
                continue;
            }
            this.addFiles(this.localList, this.syncList, dir, this.modPackDir.getAbsolutePath(), false);
        }
    }

    private void compare() {
        this.missingList = new ArrayList<FileEntry>(this.remoteList);
        this.missingList.removeAll(this.localList);
        this.outdatedList = new ArrayList<FileEntry>(this.syncList);
        this.outdatedList.removeAll(this.remoteList);
        if (RemoteInfoReader.instance().hasWhiteList() && !this.outdatedList.isEmpty()) {
            block0: for (JsonField field : RemoteInfoReader.instance().getWhileList().getFieldList()) {
                for (FileEntry file : this.outdatedList) {
                    if (!file.getMd5().equals(field.getValue().getText())) continue;
                    this.outdatedList.remove(file);
                    continue block0;
                }
            }
        }
    }

    private void addFiles(List<FileEntry> list, List<FileEntry> syncList, File dir, String modpackPath, boolean syncDir) {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                if (RemoteInfoReader.instance().enableSubFolder()) continue;
                this.addFiles(list, syncList, file, modpackPath, syncDir);
                continue;
            }
            if (syncDir) {
                syncList.add(new FileEntry(this.getMd5(file), file.getAbsolutePath().replace(modpackPath + File.separator, ""), file.length()));
            }
            list.add(new FileEntry(this.getMd5(file), file.getAbsolutePath().replace(modpackPath + File.separator, ""), file.length()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMd5(File file) {
        FilterInputStream stream = null;
        try {
            stream = new DigestInputStream(new FileInputStream(file), MessageDigest.getInstance("MD5"));
            byte[] buffer = new byte[65536];
            int read = stream.read(buffer);
            while (read >= 1) {
                read = stream.read(buffer);
            }
        }
        catch (Exception ignored) {
            String string = null;
            return string;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return String.format("%1$032x", new BigInteger(1, ((DigestInputStream)stream).getMessageDigest().digest()));
    }
}

