package fr.luky.modtutorial;

import fr.luky.modtutorial.proxy.ModTutorialCommonProxy;
import fr.luky.modtutorial.utils.References;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Logger;

@Mod(modid = References.MODID, name = References.NAME, version = References.VERSION)
public class ModTutorial {

    @Mod.Instance(References.MODID)
    public static ModTutorial instance;

    @SidedProxy(clientSide = References.CLIENT, serverSide = References.SERVEUR)
    public static ModTutorialCommonProxy proxy;

    public ModTutorial(){

    }

    public static Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event){
        logger = event.getModLog();
        proxy.preInit(event.getSuggestedConfigurationFile());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event){
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event){
        proxy.postInit();
    }

}
