/*
 * Decompiled with CFR 0.152.
 */
package fr.mcnanotech.kevin_68.thespotlightmod.client;

import fr.mcnanotech.kevin_68.thespotlightmod.TileEntitySpotLight;
import fr.mcnanotech.kevin_68.thespotlightmod.client.ModelSpotLight;
import fr.mcnanotech.kevin_68.thespotlightmod.client.text3d.Model3DTextDefault;
import fr.mcnanotech.kevin_68.thespotlightmod.client.text3d.Text3D;
import fr.mcnanotech.kevin_68.thespotlightmod.enums.EnumTSMProperty;
import fr.mcnanotech.kevin_68.thespotlightmod.objs.BeamVec;
import fr.mcnanotech.kevin_68.thespotlightmod.objs.TSMVec3;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TileEntitySpotLightRender
extends TileEntitySpecialRenderer<TileEntitySpotLight> {
    private ModelSpotLight model = new ModelSpotLight();
    private static final ResourceLocation TEXTURE = new ResourceLocation("thespotlightmod", "textures/blocks/spotlight.png");
    private static final ResourceLocation DEFAULT_BEAM = new ResourceLocation("textures/entity/beacon_beam.png");
    private static final Text3D TXT3D = new Text3D(Model3DTextDefault.instance);

    public void render(TileEntitySpotLight tile, double x, double y, double z, float tick, int destroyStage, float alpha) {
        try {
            float angleZ;
            float angleY;
            float angleX;
            boolean b0 = true;
            float f2 = (float)tile.func_145831_w().func_82737_E() + tick;
            float timer = (float)this.func_178459_a().func_82737_E() * 0.00125f;
            float f = tile.getBoolean(EnumTSMProperty.BEAM_R_AUTO_X) ? timer * (float)tile.getShort(EnumTSMProperty.BEAM_R_SPEED_X) * (tile.getBoolean(EnumTSMProperty.BEAM_R_REVERSE_X) ? -1.0f : 1.0f) : (angleX = (float)Math.toRadians(tile.getShort(EnumTSMProperty.BEAM_ANGLE_X)));
            float f3 = tile.getBoolean(EnumTSMProperty.BEAM_R_AUTO_Y) ? timer * (float)tile.getShort(EnumTSMProperty.BEAM_R_SPEED_Y) * (tile.getBoolean(EnumTSMProperty.BEAM_R_REVERSE_Y) ? -1.0f : 1.0f) : (angleY = (float)Math.toRadians(tile.getShort(EnumTSMProperty.BEAM_ANGLE_Y)));
            float f4 = tile.getBoolean(EnumTSMProperty.BEAM_R_AUTO_Z) ? timer * (float)tile.getShort(EnumTSMProperty.BEAM_R_SPEED_Z) * (tile.getBoolean(EnumTSMProperty.BEAM_R_REVERSE_Z) ? -1.0f : 1.0f) : (angleZ = (float)Math.toRadians(tile.getShort(EnumTSMProperty.BEAM_ANGLE_Z)));
            if (!tile.isBeam) {
                angleX = 0.0f;
                angleY = tile.getBoolean(EnumTSMProperty.TEXT_R_AUTO_Y) ? timer * (float)tile.getShort(EnumTSMProperty.TEXT_R_SPEED_Y) * (tile.getBoolean(EnumTSMProperty.TEXT_R_REVERSE_Y) ? -1.0f : 1.0f) : (float)Math.toRadians(tile.getShort(EnumTSMProperty.TEXT_ANGLE_Y));
                angleZ = 0.0f;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
            this.func_147499_a(TEXTURE);
            this.model.setRotation(-angleX, angleY, -angleZ);
            GlStateManager.func_179152_a((float)1.2f, (float)1.2f, (float)1.2f);
            this.model.func_78088_a(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            GlStateManager.func_179121_F();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179106_n();
            if (tile.isActive) {
                if (tile.isBeam) {
                    ItemStack s2;
                    Tessellator tess = Tessellator.func_178181_a();
                    ItemStack s = tile.func_70301_a(6);
                    if (!s.func_190926_b()) {
                        this.func_147499_a(this.getResourceLocationStack(s) != null ? this.getResourceLocationStack(s) : TextureMap.field_174945_f);
                    } else {
                        this.func_147499_a(DEFAULT_BEAM);
                    }
                    GL11.glTexParameterf((int)3553, (int)10242, (float)10497.0f);
                    GL11.glTexParameterf((int)3553, (int)10243, (float)10497.0f);
                    GlStateManager.func_179140_f();
                    GlStateManager.func_179129_p();
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
                    float f32 = -f2 * 0.2f - (float)MathHelper.func_76141_d((float)(-f2 * 0.1f));
                    double t2 = -1.0f - f32 * (tile.getFloat(EnumTSMProperty.BEAM_SPEED) - 2.0f);
                    double t3 = tile.bVec[0].getLenVec().norm() * (0.5 / Math.sqrt(Math.pow((double)b0 * ((double)tile.getShort(EnumTSMProperty.BEAM_SIZE) / 200.0), 2.0) / 2.0)) + t2;
                    double t4 = tile.bVec[1].getLenVec().norm() * (0.5 / Math.sqrt(Math.pow((double)b0 * ((double)tile.getShort(EnumTSMProperty.BEAM_SIZE) / 200.0), 2.0) / 2.0)) + t2;
                    float r = (float)tile.getShort(EnumTSMProperty.BEAM_RED) / 255.0f;
                    float g = (float)tile.getShort(EnumTSMProperty.BEAM_GREEN) / 255.0f;
                    float b = (float)tile.getShort(EnumTSMProperty.BEAM_BLUE) / 255.0f;
                    float a = tile.getFloat(EnumTSMProperty.BEAM_ALPHA);
                    if (a < 0.8f) {
                        GlStateManager.func_179132_a((boolean)false);
                    } else {
                        GlStateManager.func_179132_a((boolean)true);
                    }
                    this.drawBeam(tess, x, y, z, t2, t3, tile.bVec[0], r, g, b, a);
                    if (tile.getBoolean(EnumTSMProperty.BEAM_DOUBLE)) {
                        this.drawBeam(tess, x, y, z, t2, t4, tile.bVec[1], r, g, b, a);
                    }
                    if (!(s2 = tile.func_70301_a(7)).func_190926_b()) {
                        this.func_147499_a(this.getResourceLocationStack(s2) != null ? this.getResourceLocationStack(s2) : TextureMap.field_174945_f);
                    } else {
                        this.func_147499_a(DEFAULT_BEAM);
                    }
                    if (tile.getBoolean(EnumTSMProperty.BEAM_SEC_ENABLED)) {
                        float sR = (float)tile.getShort(EnumTSMProperty.BEAM_SEC_RED) / 255.0f;
                        float sG = (float)tile.getShort(EnumTSMProperty.BEAM_SEC_GREEN) / 255.0f;
                        float sB = (float)tile.getShort(EnumTSMProperty.BEAM_SEC_BLUE) / 255.0f;
                        float sA = tile.getFloat(EnumTSMProperty.BEAM_SEC_ALPHA);
                        if (sA < 0.8f) {
                            GlStateManager.func_179132_a((boolean)false);
                        } else {
                            GlStateManager.func_179132_a((boolean)true);
                        }
                        this.drawBeam(tess, x, y, z, t2, t3, tile.bVec[2], sR, sG, sB, sA);
                        if (tile.getBoolean(EnumTSMProperty.BEAM_DOUBLE)) {
                            this.drawBeam(tess, x, y, z, t2, t4, tile.bVec[3], sR, sG, sB, sA);
                        }
                    }
                    GlStateManager.func_179145_e();
                    GlStateManager.func_179098_w();
                    GlStateManager.func_179084_k();
                    GlStateManager.func_179132_a((boolean)true);
                } else {
                    GL11.glPushMatrix();
                    GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
                    short tscale = tile.getShort(EnumTSMProperty.TEXT_SCALE);
                    if (tile.getBoolean(EnumTSMProperty.TEXT_3D)) {
                        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        GlStateManager.func_179109_b((float)0.0f, (float)-0.2f, (float)0.0f);
                        GlStateManager.func_179114_b((float)((float)Math.toDegrees(angleY)), (float)0.0f, (float)1.0f, (float)0.0f);
                        float f21 = 0.011111112f;
                        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)(-1.0f * f21));
                        GlStateManager.func_179109_b((float)0.0f, (float)((float)(8 + tile.getShort(EnumTSMProperty.TEXT_HEIGHT)) / 10.0f), (float)0.0f);
                        GlStateManager.func_179109_b((float)0.0f, (float)(((float)tscale * 0.8f + 1.0f) / 30.0f), (float)0.0f);
                        if (tile.getShort(EnumTSMProperty.TEXT_HEIGHT) < 0) {
                            GlStateManager.func_179109_b((float)0.0f, (float)(-(26.0f + (float)tscale * 0.45f) / 20.0f), (float)0.0f);
                        }
                        GlStateManager.func_179139_a((double)(1.0 + (double)((float)tscale / 16.0f)), (double)(1.0 + (double)((float)tscale / 16.0f)), (double)(1.0 + (double)((float)tscale / 16.0f)));
                        TXT3D.renderTextAlignedCenter(tile.getBoolean(EnumTSMProperty.TEXT_TRANSLATING) ? this.getTranslatingText(tile.getString(EnumTSMProperty.TEXT), tile) : tile.getString(EnumTSMProperty.TEXT), (float)tile.getShort(EnumTSMProperty.TEXT_RED) / 255.0f, (float)tile.getShort(EnumTSMProperty.TEXT_GREEN) / 255.0f, (float)tile.getShort(EnumTSMProperty.TEXT_BLUE) / 255.0f);
                    } else {
                        GlStateManager.func_179139_a((double)0.9, (double)0.9, (double)0.9);
                        GlStateManager.func_179114_b((float)((float)Math.toDegrees(angleY)), (float)0.0f, (float)1.0f, (float)0.0f);
                        FontRenderer fontrenderer = this.func_147498_b();
                        float f21 = 0.011111112f;
                        GlStateManager.func_179152_a((float)(f21 * 5.0f), (float)(-f21 * 5.0f), (float)(f21 * 5.0f));
                        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)(-1.0f * f21));
                        GlStateManager.func_179132_a((boolean)false);
                        GlStateManager.func_179109_b((float)0.0f, (float)((float)(-tile.getShort(EnumTSMProperty.TEXT_HEIGHT)) * 2.0f), (float)0.0f);
                        GlStateManager.func_179109_b((float)0.0f, (float)((float)tscale * 0.8f + 1.0f), (float)0.0f);
                        if (tile.getShort(EnumTSMProperty.TEXT_HEIGHT) < 0) {
                            GlStateManager.func_179109_b((float)0.0f, (float)(26.0f + (float)tscale * 0.45f), (float)0.0f);
                        }
                        GlStateManager.func_179139_a((double)(1.0 + (double)((float)tscale / 16.0f)), (double)(1.0 + (double)((float)tscale / 16.0f)), (double)(1.0 + (double)((float)tscale / 16.0f)));
                        String text = (tile.getBoolean(EnumTSMProperty.TEXT_BOLD) ? TextFormatting.BOLD : "") + "" + (tile.getBoolean(EnumTSMProperty.TEXT_STRIKE) ? TextFormatting.STRIKETHROUGH : "") + "" + (tile.getBoolean(EnumTSMProperty.TEXT_UNDERLINE) ? TextFormatting.UNDERLINE : "") + "" + (tile.getBoolean(EnumTSMProperty.TEXT_ITALIC) ? TextFormatting.ITALIC : "") + "" + (tile.getBoolean(EnumTSMProperty.TEXT_OBFUSCATED) ? TextFormatting.OBFUSCATED : "") + "" + (tile.getBoolean(EnumTSMProperty.TEXT_TRANSLATING) ? this.getTranslatingText(tile.getString(EnumTSMProperty.TEXT), tile) : tile.getString(EnumTSMProperty.TEXT));
                        fontrenderer.func_175065_a(text, (float)(-fontrenderer.func_78256_a(text) / 2), -20.0f, tile.getShort(EnumTSMProperty.TEXT_RED) * 65536 + tile.getShort(EnumTSMProperty.TEXT_GREEN) * 256 + tile.getShort(EnumTSMProperty.TEXT_BLUE), tile.getBoolean(EnumTSMProperty.TEXT_SHADOW));
                        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        fontrenderer.func_175065_a(text, (float)(-fontrenderer.func_78256_a(text) / 2), -20.0f, tile.getShort(EnumTSMProperty.TEXT_RED) * 65536 + tile.getShort(EnumTSMProperty.TEXT_GREEN) * 256 + tile.getShort(EnumTSMProperty.TEXT_BLUE), tile.getBoolean(EnumTSMProperty.TEXT_SHADOW));
                        GlStateManager.func_179132_a((boolean)true);
                    }
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179121_F();
                }
            }
            GlStateManager.func_179127_m();
            GlStateManager.func_179092_a((int)516, (float)0.5f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isGlobalRenderer(TileEntitySpotLight tile) {
        return true;
    }

    public void drawBeam(Tessellator tess, double x, double y, double z, double t2, double t3, BeamVec vec, float red, float green, float blue, float alpha) {
        BufferBuilder worldrenderer = tess.func_178180_c();
        TSMVec3[] v = vec.getVecs();
        TSMVec3 e = vec.getLenVec();
        for (int i = 0; i < v.length; ++i) {
            worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            worldrenderer.func_181662_b(x + 0.5 + v[i].xCoord, y + 0.5 + v[i].yCoord, z + 0.5 + v[i].zCoord).func_187315_a(1.0, t3).func_181666_a(red, green, blue, alpha).func_181675_d();
            worldrenderer.func_181662_b(x + 0.5 + v[i].xCoord + e.xCoord, y + 0.5 + v[i].yCoord + e.yCoord, z + 0.5 + v[i].zCoord + e.zCoord).func_187315_a(1.0, t2).func_181666_a(red, green, blue, alpha).func_181675_d();
            worldrenderer.func_181662_b(x + 0.5 + v[i == v.length - 1 ? 0 : i + 1].xCoord + e.xCoord, y + 0.5 + v[i == v.length - 1 ? 0 : i + 1].yCoord + e.yCoord, z + 0.5 + v[i == v.length - 1 ? 0 : i + 1].zCoord + e.zCoord).func_187315_a(0.0, t2).func_181666_a(red, green, blue, alpha).func_181675_d();
            worldrenderer.func_181662_b(x + 0.5 + v[i == v.length - 1 ? 0 : i + 1].xCoord, y + 0.5 + v[i == v.length - 1 ? 0 : i + 1].yCoord, z + 0.5 + v[i == v.length - 1 ? 0 : i + 1].zCoord).func_187315_a(0.0, t3).func_181666_a(red, green, blue, alpha).func_181675_d();
            tess.func_78381_a();
        }
    }

    private ResourceLocation getResourceLocationStack(ItemStack stack) {
        TextureAtlasSprite sprite = null;
        Block b = Block.func_149634_a((Item)stack.func_77973_b());
        sprite = b != Blocks.field_150350_a ? Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(b.func_176203_a(stack.func_77960_j())) : Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack).func_177554_e();
        if (sprite == null) {
            return null;
        }
        String iconName = sprite.func_94215_i();
        String[] strs = iconName.split(":");
        if (strs.length > 1) {
            String resource = strs[0] + ":textures/" + strs[1] + ".png";
            return new ResourceLocation(resource);
        }
        return null;
    }

    private String getTranslatingText(String str, TileEntitySpotLight tile) {
        if (str != null && str.length() > 1) {
            int t = (int)((float)tile.func_145831_w().func_82737_E() * ((float)(tile.getShort(EnumTSMProperty.TEXT_TRANSLATE_SPEED) + 1) / 100.0f) % (float)str.length());
            if (tile.getBoolean(EnumTSMProperty.TEXT_T_REVERSE)) {
                t = str.length() - t;
            }
            return str.substring(t) + str.substring(0, t);
        }
        return str;
    }
}

