package .client;




import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Random;

 




import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;

import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiButtonLanguage;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiLanguage;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiOptions;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSelectWorld;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.demo.DemoWorldServer;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.WorldInfo;


 









import org.apache.commons.io.Charsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.glu.Project;

 









import com.google.common.base.Strings;
import com.google.common.collect.Lists;

 



import com.google.common.util.concurrent.ThreadFactoryBuilder;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.GuiModList;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fr.alfheim.mod.help.Reference;
import fr.alfheim.mod.help.ReferenceHelper;

 

@SideOnly(Side.CLIENT)

public class GuiCustomMainMenu extends GuiScreen implements GuiYesNoCallback{

    private static final Logger logger = LogManager.getLogger();

    /** The RNG used by the Main Menu Screen. */

    private static final Random rand = new Random();

    /** Counts the number of screen updates. */

    private float updateCounter;
    


    /** The splash message. */

    private String splashText;



    /** Timer used to rotate the panorama, increases every tick. */

    private int panoramaTimer;

    /**

     * Texture allocated for the current viewport of the main menu's panorama background.

     */

    private DynamicTexture viewportTexture;

    private final Object field_104025_t = new Object();

    private String field_92025_p;

    private String field_146972_A;

    private String field_104024_v;

    private static final ResourceLocation splashTexts = new ResourceLocation("texts/splashes.txt");

    private static final ResourceLocation minecraftTitleTextures = new ResourceLocation("textures/gui/title/minecraft.png");


    private static final ResourceLocation background = new ResourceLocation("cardinal", "textures/gui/background.png");

    public static final String field_96138_a = "Please click " + EnumChatFormatting.UNDERLINE + "here" + EnumChatFormatting.RESET + " for more information.";

    private int field_92024_r;

    private int field_92023_s;

    private int field_92022_t;

    private int field_92021_u;

    private int field_92020_v;

    private int field_92019_w;

    private ResourceLocation field_110351_G;

    private static final String __OBFID = "CL_00001154";
   
    
    public GuiCustomMainMenu()

    {

        this.field_146972_A = field_96138_a;

        this.splashText = "missingno";

        BufferedReader bufferedreader = null;

 

        try

        {

            ArrayList arraylist = new ArrayList();

            bufferedreader = new BufferedReader(new InputStreamReader(Minecraft.getMinecraft().getResourceManager().getResource(splashTexts).getInputStream(), Charsets.UTF_8));

            String s;

 

            while((s = bufferedreader.readLine()) != null)

            {

                s = s.trim();

 

                if(!s.isEmpty())

                {

                    arraylist.add(s);

                }

            }

 

            if(!arraylist.isEmpty())

            {

                do

                {

                    this.splashText = (String)arraylist.get(rand.nextInt(arraylist.size()));

                }

                while(this.splashText.hashCode() == 125780783);

            }

        }

        catch(IOException ioexception1)

        {

            ;

        }

        finally

        {

            if(bufferedreader != null)

            {

                try

                {

                    bufferedreader.close();

                }

                catch(IOException ioexception)

                {

                    ;

                }

            }

        }

 

        this.updateCounter = rand.nextFloat();

        this.field_92025_p = "";

 

        if(!GLContext.getCapabilities().OpenGL20 && !OpenGlHelper.func_153193_b())

        {

            this.field_92025_p = I18n.format("title.oldgl1", new Object[0]);

            this.field_146972_A = I18n.format("title.oldgl2", new Object[0]);

            this.field_104024_v = "https://help.mojang.com/customer/portal/articles/325948?ref=game";

        }

    }

 

    /**

     * Called from the main game loop to update the screen.

     */

    public void updateScreen()

    {

        ++this.panoramaTimer;

    }

 

    /**

     * Returns true if this GUI should pause the game when it is displayed in single-player

     */

    public boolean doesGuiPauseGame()

    {

        return false;

    }

 

    /**

     * Fired when a key is typed. This is the equivalent of KeyListener.keyTyped(KeyEvent e).

     */

    protected void keyTyped(char p_73869_1_, int p_73869_2_)

    {}

 

    /**

     * Adds the buttons (and other controls) to the screen in question.

     */

    public void initGui()

    {

        this.viewportTexture = new DynamicTexture(256, 256);

        this.field_110351_G = this.mc.getTextureManager().getDynamicTextureLocation("background", this.viewportTexture);

 

        boolean flag = true;

        int i = this.height / 4 + 48;


        this.buttonList.add(new GuiButtonPlay(20, this.width / 2 - 100, i + 72 + 12));

        this.buttonList.add(new GuiButtonOption(0, this.width / 2 - 100, i + 72 + 12));

        this.buttonList.add(new GuiButtonQuit(4, this.width / 2 + 2, i + 72 + 12));

        this.buttonList.add(new GuiButtonLanguage(5, this.width / 2 - 124, i + 72 + 12));

        this.buttonList.add(new GuiButtonDiscord(21, this.width / 2 - 124, i + 24));

        Object object = this.field_104025_t;

 

        synchronized(this.field_104025_t)

        {

            this.field_92023_s = this.fontRendererObj.getStringWidth(this.field_92025_p);

            this.field_92024_r = this.fontRendererObj.getStringWidth(this.field_146972_A);

            int j = Math.max(this.field_92023_s, this.field_92024_r);

            this.field_92022_t = (this.width - j) / 2;

            this.field_92021_u = ((GuiButton)this.buttonList.get(0)).yPosition - 24;

            this.field_92020_v = this.field_92022_t + j;

            this.field_92019_w = this.field_92021_u + 24;

        }

    }

 






    protected void actionPerformed(GuiButton button)

    {

        if(button.id == 0)

        {

            this.mc.displayGuiScreen(new GuiOptions(this, this.mc.gameSettings));

        }

 

        if(button.id == 5)

        {

            this.mc.displayGuiScreen(new GuiLanguage(this, this.mc.gameSettings, this.mc.getLanguageManager()));

        }

 


 

        if(button.id == 4)

        {

            this.mc.shutdown();

        }

        if(button.id == 12)

        {

            ISaveFormat isaveformat = this.mc.getSaveLoader();

            WorldInfo worldinfo = isaveformat.getWorldInfo("Demo_World");

 

            if(worldinfo != null)

            {

                GuiYesNo guiyesno = GuiSelectWorld.func_152129_a(this, worldinfo.getWorldName(), 12);

                this.mc.displayGuiScreen(guiyesno);

            }

        }

 

        if(button.id == 20)

        {

            FMLClientHandler.instance().connectToServerAtStartup("localhost", 25565); // ip, port

        }

 

        if(button.id == 21)

        {

            try

            {

                Class oclass = Class.forName("java.awt.Desktop");

                Object object = oclass.getMethod("getDesktop", new Class[0]).invoke((Object)null, new Object[0]);

                oclass.getMethod("browse", new Class[] {URI.class}).invoke(object, new Object[] {new URI("url de ton site")});

            }

            catch(Throwable throwable)

            {

                logger.error("Couldn\'t open link", throwable);

            }

        }

    }

 

    public void confirmClicked(boolean p_73878_1_, int id)

    {



        if(id == 13)

        {

            if(p_73878_1_)

            {

                try

                {

                    Class oclass = Class.forName("java.awt.Desktop");

                    Object object = oclass.getMethod("getDesktop", new Class[0]).invoke((Object)null, new Object[0]);

                    oclass.getMethod("browse", new Class[] {URI.class}).invoke(object, new Object[] {new URI(this.field_104024_v)});

                }

                catch(Throwable throwable)

                {

                    logger.error("Couldn\'t open link", throwable);

                }

            }

 

            this.mc.displayGuiScreen(this);

        }

    }

 

    public void drawBackground()

    {

        GL11.glDisable(GL11.GL_LIGHTING);

        GL11.glDisable(GL11.GL_FOG);

        Tessellator var2 = Tessellator.instance;

        GL11.glBindTexture(GL11.GL_TEXTURE_2D, 0);

        this.mc.getTextureManager().bindTexture(background);

        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);

        var2.startDrawingQuads();

        var2.addVertexWithUV(0.0D, (double)this.height, 0.0D, 0.0D, 1.0D);

        var2.addVertexWithUV((double)this.width, (double)this.height, 0.0D, 1.0D, 1.0D);

        var2.addVertexWithUV((double)this.width, 0.0D, 0.0D, 1.0D, 0.0D);

        var2.addVertexWithUV(0.0D, 0.0D, 0.0D, 0.0D, 0.0D);

        var2.draw();

    }

    /**

     * Draws the main menu panorama

     */

 

    /**

     * Rotate and blurs the skybox view in the main menu

     */

    private void rotateAndBlurSkybox(float partialTick)

    {

        this.mc.getTextureManager().bindTexture(this.field_110351_G);

        GL11.glTexParameteri(GL11.GL_TEXTURE_2D, GL11.GL_TEXTURE_MIN_FILTER, GL11.GL_LINEAR);

        GL11.glTexParameteri(GL11.GL_TEXTURE_2D, GL11.GL_TEXTURE_MAG_FILTER, GL11.GL_LINEAR);

        GL11.glCopyTexSubImage2D(GL11.GL_TEXTURE_2D, 0, 0, 0, 0, 0, 256, 256);

        GL11.glEnable(GL11.GL_BLEND);

        OpenGlHelper.glBlendFunc(770, 771, 1, 0);

        GL11.glColorMask(true, true, true, false);

        Tessellator tessellator = Tessellator.instance;

        tessellator.startDrawingQuads();

        GL11.glDisable(GL11.GL_ALPHA_TEST);

        byte b0 = 3;

 

        for(int i = 0; i < b0; ++i)

        {

            tessellator.setColorRGBA_F(1.0F, 1.0F, 1.0F, 1.0F / (float)(i + 1));

            int j = this.width;

            int k = this.height;

            float f1 = (float)(i - b0 / 2) / 256.0F;

            tessellator.addVertexWithUV((double)j, (double)k, (double)this.zLevel, (double)(0.0F + f1), 1.0D);

            tessellator.addVertexWithUV((double)j, 0.0D, (double)this.zLevel, (double)(1.0F + f1), 1.0D);

            tessellator.addVertexWithUV(0.0D, 0.0D, (double)this.zLevel, (double)(1.0F + f1), 0.0D);

            tessellator.addVertexWithUV(0.0D, (double)k, (double)this.zLevel, (double)(0.0F + f1), 0.0D);

        }

 

        tessellator.draw();

        GL11.glEnable(GL11.GL_ALPHA_TEST);

        GL11.glColorMask(true, true, true, true);

    }

 

    /**

     * Renders the skybox in the main menu

     */

    private void renderSkybox(int x, int y, float partialTick)

    {

        this.mc.getFramebuffer().unbindFramebuffer();

        GL11.glViewport(0, 0, 256, 256);

 

        this.mc.getFramebuffer().bindFramebuffer(true);

        GL11.glViewport(0, 0, this.mc.displayWidth, this.mc.displayHeight);

        Tessellator tessellator = Tessellator.instance;

        tessellator.startDrawingQuads();

        float f1 = this.width > this.height ? 120.0F / (float)this.width : 120.0F / (float)this.height;

        float f2 = (float)this.height * f1 / 256.0F;

        float f3 = (float)this.width * f1 / 256.0F;

        tessellator.setColorRGBA_F(1.0F, 1.0F, 1.0F, 1.0F);

        int k = this.width;

        int l = this.height;

        tessellator.addVertexWithUV(0.0D, (double)l, (double)this.zLevel, (double)(0.5F - f2), (double)(0.5F + f3));

        tessellator.addVertexWithUV((double)k, (double)l, (double)this.zLevel, (double)(0.5F - f2), (double)(0.5F - f3));

        tessellator.addVertexWithUV((double)k, 0.0D, (double)this.zLevel, (double)(0.5F + f2), (double)(0.5F - f3));

        tessellator.addVertexWithUV(0.0D, 0.0D, (double)this.zLevel, (double)(0.5F + f2), (double)(0.5F + f3));

        tessellator.draw();

    }

 

    /**

     * Draws the screen and all the components in it.

     */

    public void drawScreen(int x, int y, float partialTick)

    {
        GL11.glDisable(GL11.GL_ALPHA_TEST);

        GL11.glEnable(GL11.GL_ALPHA_TEST);

        Tessellator tessellator = Tessellator.instance;

        short short1 = 274;

        int k = this.width / 2 - short1 / 2;

        byte b0 = 30;

        this.drawGradientRect(0, 0, this.width, this.height, -2130706433, 16777215);

        this.drawGradientRect(0, 0, this.width, this.height, 0, Integer.MIN_VALUE);

        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);

        this.drawBackground();

        tessellator.setColorOpaque_I(-1);

        GL11.glPushMatrix();

        GL11.glTranslatef((float)(this.width / 2 + 90), 70.0F, 0.0F);

        GL11.glRotatef(-20.0F, 0.0F, 0.0F, 1.0F);

        float f1 = 1.8F - MathHelper.abs(MathHelper.sin((float)(Minecraft.getSystemTime() % 1000L) / 1000.0F * (float)Math.PI * 2.0F) * 0.1F);

        GL11.glScalef(f1, f1, f1);

        GL11.glPopMatrix();

        String s = "Minecraft 1.7.10";

 


 

        List<String> brandings = Lists.reverse(FMLCommonHandler.instance().getBrandings(true));

        for(int i = 0; i < brandings.size(); i++)

        {

            String brd = brandings.get(i);

            if(!Strings.isNullOrEmpty(brd))

            {

                this.drawString(this.fontRendererObj, brd, 2, this.height - (10 + i * (this.fontRendererObj.FONT_HEIGHT + 1)), 16777215);

            }

        }

 

        if(this.field_92025_p != null && this.field_92025_p.length() > 0)

        {

            drawRect(this.field_92022_t - 2, this.field_92021_u - 2, this.field_92020_v + 2, this.field_92019_w - 1, 1428160512);

            this.drawString(this.fontRendererObj, this.field_92025_p, this.field_92022_t, this.field_92021_u, -1);

            this.drawString(this.fontRendererObj, this.field_146972_A, (this.width - this.field_92024_r) / 2, ((GuiButton)this.buttonList.get(0)).yPosition - 12, -1);

        }

 

        super.drawScreen(x, y, partialTick);

    }

 

    /**

     * Called when the mouse is clicked.

     */

    protected void mouseClicked(int p_73864_1_, int p_73864_2_, int p_73864_3_)

    {

        super.mouseClicked(p_73864_1_, p_73864_2_, p_73864_3_);

        Object object = this.field_104025_t;

 

        synchronized(this.field_104025_t)

        {

            if(this.field_92025_p.length() > 0 && p_73864_1_ >= this.field_92022_t && p_73864_1_ <= this.field_92020_v && p_73864_2_ >= this.field_92021_u && p_73864_2_ <= this.field_92019_w)

            {

                GuiConfirmOpenLink guiconfirmopenlink = new GuiConfirmOpenLink(this, this.field_104024_v, 13, true);

                guiconfirmopenlink.func_146358_g();

                this.mc.displayGuiScreen(guiconfirmopenlink);

            }

        }

    }

}