/*
 * Decompiled with CFR 0.152.
 */
package neo.extdeco.blocks;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import neo.extdeco.blocks.BlocksExtDeco;
import neo.extdeco.entitys.ParticleFreezer;
import neo.extdeco.init.ExtDeco;
import neo.extdeco.tileentitys.TileEntityFreezer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class BlockFreezer
extends BlockContainer {
    @SideOnly(value=Side.CLIENT)
    protected IIcon field_149761_L;
    @SideOnly(value=Side.CLIENT)
    protected IIcon blockIconTop;
    @SideOnly(value=Side.CLIENT)
    protected IIcon blockIconFront;
    private String rawName;
    private final boolean isBurning2;
    private static boolean isBurning;
    private final Random random = new Random();

    public BlockFreezer(String rawName, Float hardness, boolean isBurning) {
        super(Material.field_151576_e);
        this.rawName = rawName;
        this.func_149663_c("extdeco:" + rawName);
        this.isBurning2 = isBurning;
        this.func_149711_c(hardness.floatValue());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("extdeco:freezer/freezer");
        this.blockIconFront = iconRegister.func_94245_a(this.isBurning2 ? "extdeco:freezer/freezerActive" : "extdeco:freezer/freezerInactive");
        this.blockIconTop = iconRegister.func_94245_a("extdeco:freezer/freezerTop");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (meta == 0 && side == 3) {
            return this.blockIconFront;
        }
        return side == 1 ? this.blockIconTop : (side == 0 ? this.blockIconTop : (side != meta ? this.field_149761_L : this.blockIconFront));
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        player.openGui((Object)ExtDeco.modInstance, 0, world, x, y, z);
        return true;
    }

    public Item func_149650_a(int par1, Random random, int par3) {
        return Item.func_150898_a((Block)BlocksExtDeco.freezer);
    }

    public TileEntity func_149915_a(World world, int par2) {
        return new TileEntityFreezer();
    }

    public void onBlockAdded(World world, int i, int j, int k, EntityLivingBase entity, ItemStack p_149689_6_) {
        super.func_149726_b(world, i, j, k);
        this.setDefaultDirection(world, i, j, k);
    }

    private void setDefaultDirection(World par1World, int par2, int par3, int par4) {
        if (!par1World.field_72995_K) {
            Block l = par1World.func_147439_a(par2, par3, par4 - 1);
            Block i1 = par1World.func_147439_a(par2, par3, par4 + 1);
            Block j1 = par1World.func_147439_a(par2 - 1, par3, par4);
            Block k1 = par1World.func_147439_a(par2 + 1, par3, par4);
            int b0 = 3;
            if (l.func_149730_j() && !i1.func_149730_j()) {
                b0 = 3;
            }
            if (i1.func_149730_j() && !l.func_149730_j()) {
                b0 = 4;
            }
            if (j1.func_149730_j() && !k1.func_149730_j()) {
                b0 = 2;
            }
            if (k1.func_149730_j() && !j1.func_149730_j()) {
                b0 = 5;
            }
            par1World.func_72921_c(par2, par3, par4, b0, 2);
        }
    }

    public byte rotateBlock(byte b0, EntityLivingBase entity) {
        if (entity.field_70177_z >= 135.0f && entity.field_70177_z <= 181.0f || entity.field_70177_z <= -135.0f && entity.field_70177_z >= -181.0f) {
            b0 = (byte)3;
        } else if (entity.field_70177_z > -135.0f && entity.field_70177_z < -45.0f) {
            b0 = (byte)4;
        } else if (entity.field_70177_z >= -45.0f && entity.field_70177_z <= 45.0f) {
            b0 = (byte)2;
        } else if (entity.field_70177_z > 45.0f && entity.field_70177_z < 135.0f) {
            b0 = (byte)5;
        } else if (entity.field_70177_z >= 181.0f) {
            entity.field_70177_z -= 360.0f;
            b0 = this.rotateBlock(b0, entity);
        } else if (entity.field_70177_z <= -181.0f) {
            entity.field_70177_z += 360.0f;
            b0 = this.rotateBlock(b0, entity);
        }
        return b0;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemstack) {
        int direction = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (direction == 0) {
            world.func_72921_c(x, y, z, 2, 2);
        }
        if (direction == 1) {
            world.func_72921_c(x, y, z, 5, 2);
        }
        if (direction == 2) {
            world.func_72921_c(x, y, z, 3, 2);
        }
        if (direction == 3) {
            world.func_72921_c(x, y, z, 4, 2);
        }
        if (itemstack.func_82837_s()) {
            ((TileEntityFreezer)world.func_147438_o(x, y, z)).freezerName(itemstack.func_82833_r());
        }
    }

    public static void updateFreezerBlockState(boolean burning, World world, int x, int y, int z) {
        int direction = world.func_72805_g(x, y, z);
        TileEntity tileentity = world.func_147438_o(x, y, z);
        isBurning = true;
        if (burning) {
            world.func_147449_b(x, y, z, BlocksExtDeco.freezerOn);
        } else {
            world.func_147449_b(x, y, z, BlocksExtDeco.freezer);
        }
        isBurning = false;
        world.func_72921_c(x, y, z, direction, 2);
        if (tileentity != null) {
            tileentity.func_145829_t();
            world.func_147455_a(x, y, z, tileentity);
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntityFreezer tileentitytutfurnace;
        if (!isBurning && (tileentitytutfurnace = (TileEntityFreezer)world.func_147438_o(x, y, z)) != null) {
            for (int i = 0; i < tileentitytutfurnace.func_70302_i_(); ++i) {
                ItemStack itemstack = tileentitytutfurnace.func_70301_a(i);
                if (itemstack == null) continue;
                float f = this.random.nextFloat() * 0.6f + 0.1f;
                float f1 = this.random.nextFloat() * 0.6f + 0.1f;
                float f2 = this.random.nextFloat() * 0.6f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int j = this.random.nextInt(21) + 10;
                    if (j > itemstack.field_77994_a) {
                        j = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= j;
                    EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(itemstack.func_77973_b(), j, itemstack.func_77960_j()));
                    if (itemstack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    float f3 = 0.025f;
                    entityitem.field_70159_w = (float)this.random.nextGaussian() * f3;
                    entityitem.field_70181_x = (float)this.random.nextGaussian() * f3 + 0.1f;
                    entityitem.field_70179_y = (float)this.random.nextGaussian() * f3;
                    world.func_72838_d((Entity)entityitem);
                }
            }
            world.func_147453_f(x, y, z, block);
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        if (this.isBurning2) {
            EffectRenderer effect = FMLClientHandler.instance().getClient().field_71452_i;
            int l = world.func_72805_g(x, y, z);
            float f = (float)x + 0.5f;
            float f1 = (float)y + 0.0f + random.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)z + 0.5f;
            float f3 = 0.52f;
            float f4 = random.nextFloat() * 0.6f - 0.3f;
            if (l == 4) {
                effect.func_78873_a((EntityFX)new ParticleFreezer(world, f - f3, f1, f2 + f4, 0.0, 0.0, 0.0));
            } else if (l == 5) {
                effect.func_78873_a((EntityFX)new ParticleFreezer(world, f + f3, f1, f2 + f4, 0.0, 0.0, 0.0));
            } else if (l == 2) {
                effect.func_78873_a((EntityFX)new ParticleFreezer(world, f + f4, f1, f2 - f3, 0.0, 0.0, 0.0));
            } else if (l == 3) {
                effect.func_78873_a((EntityFX)new ParticleFreezer(world, f + f4, f1, f2 + f3, 0.0, 0.0, 0.0));
            }
        }
    }
}

