package com.lymbow.mod.items;

import com.lymbow.mod.Reference;
import com.lymbow.mod.entity.EntityGrenade;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemObsidianBreakerLymbowMod extends Item
{
    public ItemObsidianBreakerLymbowMod() {
    	this.setMaxStackSize(1);
        this.setMaxDamage(9);
        this.canRepair = false;
    }
    
    @Override
    public boolean onItemUse(ItemStack item, EntityPlayer player, World world, int x, int y, int z, int p_77648_7_, float p_77648_8_, float p_77648_9_, float p_77648_10_) {
    	if(world.getBlock(x,y,z) == Blocks.obsidian && !player.capabilities.isCreativeMode)
    	{
    		world.spawnParticle("flame", x + 0.5, y + 0.5, z + 0.5, 0.0D, 0.0D, 0.0D);
    		world.playSoundEffect(player.posX + 0.5D, player.posY + 0.5D, player.posZ + 0.5D, "mob.endermen.portal", 1.0F, 1.0F);
    		world.setBlockToAir(x, y, z);
        	item.damageItem(1, player);
    	}
    	return super.onItemUse(item, player, world, x, y, z, p_77648_7_, p_77648_8_, p_77648_9_, p_77648_10_);
    }
}
