package com.lymbow.mod.items;

import com.lymbow.mod.entity.EntityGrenade;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemGrenadeLymbowMod extends Item
{
    @Override
    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player)
    {
        if (player.canPlayerEdit((int)player.posX, (int)player.posY, (int)player.posZ, 0, player.getHeldItem()))
        {
            if (!player.capabilities.isCreativeMode)
            {
                --stack.stackSize;
            }
            world.playSoundAtEntity(player, "random.fizz", 0.7F, 0.8F);

            if (!world.isRemote)
            {
                EntityGrenade ent = new EntityGrenade(world, player);
                ent.motionY /= 2.0F;
                ent.motionX /= 3.0F;
                ent.motionZ /= 3.0F;
                world.spawnEntityInWorld(ent);
            }
        }

        return stack;
    }
}
