package com.lymbow.mod.items;

import com.lymbow.mod.Reference;
import com.lymbow.mod.init.ItemMod;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;

public class ItemArmorLymbowMod extends ItemArmor
{

    public ItemArmorLymbowMod(ArmorMaterial material, int metaData)
    {
        super(material, 0, metaData);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type)
    {
        if (stack.getItem() == ItemMod.adamantium_leggings)
        {
            return Reference.MOD_ID + ":textures/models/armor/adamantium_layer_2.png";
        }
        else if (stack.getItem() == ItemMod.adamantium_helmet || stack.getItem() == ItemMod.adamantium_chestplate || stack.getItem() == ItemMod.adamantium_boots)
        {
            return Reference.MOD_ID + ":textures/models/armor/adamantium_layer_1.png";
        }


        if (stack.getItem() == ItemMod.mythril_leggings)
        {
            return Reference.MOD_ID + ":textures/models/armor/mythril_layer_2.png";
        }
        else if (stack.getItem() == ItemMod.mythril_helmet || stack.getItem() == ItemMod.mythril_chestplate || stack.getItem() == ItemMod.mythril_boots)
        {
            return Reference.MOD_ID + ":textures/models/armor/mythril_layer_1.png";
        }


        if (stack.getItem() == ItemMod.cobalt_leggings)
        {
            return Reference.MOD_ID + ":textures/models/armor/cobalt_layer_2.png";
        }
        else if (stack.getItem() == ItemMod.cobalt_helmet || stack.getItem() == ItemMod.cobalt_chestplate || stack.getItem() == ItemMod.cobalt_boots)
        {
            return Reference.MOD_ID + ":textures/models/armor/cobalt_layer_1.png";
        }


        return null;
    }
}
