package com.lymbow.mod.init;

import com.lymbow.mod.LymbowMod;
import com.lymbow.mod.Reference;
import com.lymbow.mod.items.*;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.Item.ToolMaterial;
import net.minecraft.item.ItemArmor.ArmorMaterial;
import net.minecraftforge.common.util.EnumHelper;

public class ItemMod
{
    public static ToolMaterial COBALTTOOL = EnumHelper.addToolMaterial("ADAMANTIUMTOOL", 3, 2000, 12, 4, 30);
    public static ToolMaterial MYTHRILTOOL = EnumHelper.addToolMaterial("COBALTTOOL", 3, 2500, 15, 5, 35);
    public static ToolMaterial ADAMANTIUMTOOL = EnumHelper.addToolMaterial("ADAMANTIUMTOOL", 3, 3000, 18, 6, 40);

    public static ArmorMaterial COBALTARMOR = EnumHelper.addArmorMaterial("COBALTARMOR", 160, new int[]{
            3,
            9,
            6,
            3
    }, 30);
    public static ArmorMaterial MYTHRILARMOR = EnumHelper.addArmorMaterial("MYTHRILARMOR", 200, new int[]{
            3,
            10,
            6,
            3
    }, 35);
    public static ArmorMaterial ADAMANTIUMARMOR = EnumHelper.addArmorMaterial("ADAMANTIUMARMOR", 240, new int[]{
            3,
            11,
            7,
            3
    }, 35);

    public static Item grenade;

    public static Item adamantium_ingot, mythril_ingot, cobalt_ingot;

    public static Item adamantium_sword, adamantium_pickaxe, adamantium_axe, adamantium_shovel, adamantium_hoe;
    public static Item mythril_sword, mythril_pickaxe, mythril_axe, mythril_shovel, mythril_hoe;
    public static Item cobalt_sword, cobalt_pickaxe, cobalt_axe, cobalt_shovel, cobalt_hoe;

    public static Item adamantium_helmet, adamantium_chestplate, adamantium_leggings, adamantium_boots;
    public static Item mythril_helmet, mythril_chestplate, mythril_leggings, mythril_boots;
    public static Item cobalt_helmet, cobalt_chestplate, cobalt_leggings, cobalt_boots;

    public static Item mythril_hammer, cobalt_hammer, adamantium_hammer;

    public static Item storage_finder;

    public static Item obsidian_breaker;

    public static void init()
    {
        grenade = new ItemGrenadeLymbowMod().setUnlocalizedName("grenade").setCreativeTab(LymbowMod.tabLymbow).setTextureName(Reference.MOD_ID + ":Grenade");

        adamantium_ingot = new Item().setUnlocalizedName("adamantium_ingot").setCreativeTab(CreativeTabs.tabMaterials).setTextureName(Reference.MOD_ID + ":AdamantiumIngot");
        mythril_ingot = new Item().setUnlocalizedName("lymbow_ingot").setCreativeTab(CreativeTabs.tabMaterials).setTextureName(Reference.MOD_ID + ":MythrilIngot");
        cobalt_ingot = new Item().setUnlocalizedName("cobalt_ingot").setCreativeTab(CreativeTabs.tabMaterials).setTextureName(Reference.MOD_ID + ":CobaltIngot");
        
        cobalt_sword = new ItemSwordLymbowMod(ItemMod.COBALTTOOL).setUnlocalizedName("cobalt_sword").setCreativeTab(CreativeTabs.tabCombat).setTextureName(Reference.MOD_ID + ":CobaltSword");
        cobalt_pickaxe = new ItemPickaxeLymbowMod(ItemMod.COBALTTOOL).setUnlocalizedName("cobalt_pickaxe").setCreativeTab(CreativeTabs.tabTools).setTextureName(Reference.MOD_ID + ":CobaltPickaxe");
        cobalt_axe = new ItemAxeLymbowMod(ItemMod.COBALTTOOL).setUnlocalizedName("cobalt_axe").setCreativeTab(CreativeTabs.tabTools).setTextureName(Reference.MOD_ID + ":CobaltAxe");
        cobalt_shovel = new ItemShovelLymbowMod(ItemMod.COBALTTOOL).setUnlocalizedName("cobalt_shovel").setCreativeTab(CreativeTabs.tabTools).setTextureName(Reference.MOD_ID + ":CobaltShovel");
        cobalt_hoe = new ItemHoeLymbowMod(ItemMod.COBALTTOOL).setUnlocalizedName("cobalt_hoe").setCreativeTab(CreativeTabs.tabTools).setTextureName(Reference.MOD_ID + ":CobaltHoe");
        
        mythril_sword = new ItemSwordLymbowMod(ItemMod.MYTHRILTOOL).setUnlocalizedName("mythril_sword").setCreativeTab(CreativeTabs.tabCombat).setTextureName(Reference.MOD_ID + ":MythrilSword");
        mythril_pickaxe = new ItemPickaxeLymbowMod(ItemMod.MYTHRILTOOL).setUnlocalizedName("mythril_pickaxe").setCreativeTab(CreativeTabs.tabTools).setTextureName(Reference.MOD_ID + ":MythrilPickaxe");
        mythril_axe = new ItemAxeLymbowMod(ItemMod.MYTHRILTOOL).setUnlocalizedName("mythril_axe").setCreativeTab(CreativeTabs.tabTools).setTextureName(Reference.MOD_ID + ":MythrilAxe");
        mythril_shovel = new ItemShovelLymbowMod(ItemMod.MYTHRILTOOL).setUnlocalizedName("mythril_shovel").setCreativeTab(CreativeTabs.tabTools).setTextureName(Reference.MOD_ID + ":MythrilShovel");
        mythril_hoe = new ItemHoeLymbowMod(ItemMod.MYTHRILTOOL).setUnlocalizedName("mythril_hoe").setCreativeTab(CreativeTabs.tabTools).setTextureName(Reference.MOD_ID + ":MythrilHoe");

        adamantium_sword = new ItemSwordLymbowMod(ItemMod.ADAMANTIUMTOOL).setUnlocalizedName("adamantium_sword").setCreativeTab(CreativeTabs.tabCombat).setTextureName(Reference.MOD_ID + ":AdamantiumSword");
        adamantium_pickaxe = new ItemPickaxeLymbowMod(ItemMod.ADAMANTIUMTOOL).setUnlocalizedName("adamantium_pickaxe").setCreativeTab(CreativeTabs.tabTools).setTextureName(Reference.MOD_ID + ":AdamantiumPickaxe");
        adamantium_axe = new ItemAxeLymbowMod(ItemMod.ADAMANTIUMTOOL).setUnlocalizedName("adamantium_axe").setCreativeTab(CreativeTabs.tabTools).setTextureName(Reference.MOD_ID + ":AdamantiumAxe");
        adamantium_shovel = new ItemShovelLymbowMod(ItemMod.ADAMANTIUMTOOL).setUnlocalizedName("adamantium_shovel").setCreativeTab(CreativeTabs.tabTools).setTextureName(Reference.MOD_ID + ":AdamantiumShovel");
        adamantium_hoe = new ItemHoeLymbowMod(ItemMod.ADAMANTIUMTOOL).setUnlocalizedName("adamantium_hoe").setCreativeTab(CreativeTabs.tabTools).setTextureName(Reference.MOD_ID + ":AdamantiumHoe");

        cobalt_helmet = new ItemArmorLymbowMod(COBALTARMOR, 0).setCreativeTab(CreativeTabs.tabCombat).setTextureName(Reference.MOD_ID + ":CobaltHelmet").setUnlocalizedName("cobalt_helmet");
        cobalt_chestplate = new ItemArmorLymbowMod(COBALTARMOR, 1).setCreativeTab(CreativeTabs.tabCombat).setTextureName(Reference.MOD_ID + ":CobaltChestplate").setUnlocalizedName("cobalt_chestplate");
        cobalt_leggings = new ItemArmorLymbowMod(COBALTARMOR, 2).setCreativeTab(CreativeTabs.tabCombat).setTextureName(Reference.MOD_ID + ":CobaltLeggings").setUnlocalizedName("cobalt_leggings");
        cobalt_boots = new ItemArmorLymbowMod(COBALTARMOR, 3).setCreativeTab(CreativeTabs.tabCombat).setTextureName(Reference.MOD_ID + ":CobaltBoots").setUnlocalizedName("cobalt_boots");

        mythril_helmet = new ItemArmorLymbowMod(MYTHRILARMOR, 0).setCreativeTab(CreativeTabs.tabCombat).setTextureName(Reference.MOD_ID + ":MythrilHelmet").setUnlocalizedName("mythril_helmet");
        mythril_chestplate = new ItemArmorLymbowMod(MYTHRILARMOR, 1).setCreativeTab(CreativeTabs.tabCombat).setTextureName(Reference.MOD_ID + ":MythrilChestplate").setUnlocalizedName("mythril_chestplate");
        mythril_leggings = new ItemArmorLymbowMod(MYTHRILARMOR, 2).setCreativeTab(CreativeTabs.tabCombat).setTextureName(Reference.MOD_ID + ":MythrilLeggings").setUnlocalizedName("mythril_leggings");
        mythril_boots = new ItemArmorLymbowMod(MYTHRILARMOR, 3).setCreativeTab(CreativeTabs.tabCombat).setTextureName(Reference.MOD_ID + ":MythrilBoots").setUnlocalizedName("mythril_boots");

        adamantium_helmet = new ItemArmorLymbowMod(ADAMANTIUMARMOR, 0).setCreativeTab(CreativeTabs.tabCombat).setTextureName(Reference.MOD_ID + ":AdamantiumHelmet").setUnlocalizedName("adamantium_helmet");
        adamantium_chestplate = new ItemArmorLymbowMod(ADAMANTIUMARMOR, 1).setCreativeTab(CreativeTabs.tabCombat).setTextureName(Reference.MOD_ID + ":AdamantiumChestplate").setUnlocalizedName("adamantium_chestplate");
        adamantium_leggings = new ItemArmorLymbowMod(ADAMANTIUMARMOR, 2).setCreativeTab(CreativeTabs.tabCombat).setTextureName(Reference.MOD_ID + ":AdamantiumLeggings").setUnlocalizedName("adamantium_leggings");
        adamantium_boots = new ItemArmorLymbowMod(ADAMANTIUMARMOR, 3).setCreativeTab(CreativeTabs.tabCombat).setTextureName(Reference.MOD_ID + ":AdamantiumBoots").setUnlocalizedName("adamantium_boots");
        
        adamantium_hammer = new ItemHammerLymbowMod(ItemMod.ADAMANTIUMTOOL).setUnlocalizedName("adamantium_hammer").setCreativeTab(CreativeTabs.tabTools).setTextureName(Reference.MOD_ID + ":AdamantiumHammer");
        mythril_hammer = new ItemHammerLymbowMod(ItemMod.MYTHRILTOOL).setUnlocalizedName("mythril_hammer").setCreativeTab(CreativeTabs.tabTools).setTextureName(Reference.MOD_ID + ":MythrilHammer");
        cobalt_hammer = new ItemHammerLymbowMod(ItemMod.COBALTTOOL).setUnlocalizedName("cobalt_hammer").setCreativeTab(CreativeTabs.tabTools).setTextureName(Reference.MOD_ID + ":CobaltHammer");

        storage_finder = new ItemBasicLymbowMod().setUnlocalizedName("storage_finder").setTextureName(Reference.MOD_ID + ":StorageFinder").setCreativeTab(LymbowMod.tabLymbow);
        
        obsidian_breaker = new ItemObsidianBreakerLymbowMod().setUnlocalizedName("obsidian_breaker").setTextureName(Reference.MOD_ID + ":ObsidianBreaker").setCreativeTab(LymbowMod.tabLymbow);
    }

    public static void register()
    {
        GameRegistry.registerItem(grenade, "grenade");

        GameRegistry.registerItem(cobalt_ingot, "cobalt_ingot");
        GameRegistry.registerItem(mythril_ingot, "mythril_ingot");
        GameRegistry.registerItem(adamantium_ingot, "adamantium_ingot");

        GameRegistry.registerItem(cobalt_sword, "cobalt_sword");
        GameRegistry.registerItem(cobalt_pickaxe, "cobalt_pickaxe");
        GameRegistry.registerItem(cobalt_axe, "cobalt_axe");
        GameRegistry.registerItem(cobalt_shovel, "cobalt_shovel");
        GameRegistry.registerItem(cobalt_hoe, "cobalt_hoe");

        GameRegistry.registerItem(mythril_sword, "mythril_sword");
        GameRegistry.registerItem(mythril_pickaxe, "mythril_pickaxe");
        GameRegistry.registerItem(mythril_axe, "mythril_axe");
        GameRegistry.registerItem(mythril_shovel, "mythril_shovel");
        GameRegistry.registerItem(mythril_hoe, "mythril_hoe");

        GameRegistry.registerItem(adamantium_sword, "adamantium_sword");
        GameRegistry.registerItem(adamantium_pickaxe, "adamantium_pickaxe");
        GameRegistry.registerItem(adamantium_axe, "adamantium_axe");
        GameRegistry.registerItem(adamantium_shovel, "adamantium_shovel");
        GameRegistry.registerItem(adamantium_hoe, "adamantium_hoe");

        GameRegistry.registerItem(cobalt_helmet, "cobalt_helmet");
        GameRegistry.registerItem(cobalt_chestplate, "cobalt_chestplate");
        GameRegistry.registerItem(cobalt_leggings, "cobalt_leggings");
        GameRegistry.registerItem(cobalt_boots, "cobalt_boots");

        GameRegistry.registerItem(mythril_helmet, "mythril_helmet");
        GameRegistry.registerItem(mythril_chestplate, "mythril_chestplate");
        GameRegistry.registerItem(mythril_leggings, "mythril_leggings");
        GameRegistry.registerItem(mythril_boots, "mythril_boots");

        GameRegistry.registerItem(adamantium_helmet, "adamantium_helmet");
        GameRegistry.registerItem(adamantium_chestplate, "adamantium_chestplate");
        GameRegistry.registerItem(adamantium_leggings, "adamantium_leggings");
        GameRegistry.registerItem(adamantium_boots, "adamantium_boots");

        GameRegistry.registerItem(cobalt_hammer, "cobalt_hammer");
        GameRegistry.registerItem(mythril_hammer, "mythril_hammer");
        GameRegistry.registerItem(adamantium_hammer, "adamantium_hammer");

        GameRegistry.registerItem(storage_finder, "storage_finder");
        
        GameRegistry.registerItem(obsidian_breaker, "obsidian_breaker");
    }
}