package com.lymbow.mod.init;

import com.lymbow.mod.LymbowMod;
import com.lymbow.mod.Reference;
import com.lymbow.mod.blocks.BaseFinderBlock;
import com.lymbow.mod.blocks.BlockBasic;
import com.lymbow.mod.blocks.BlockCraftingMachine;
import com.lymbow.mod.blocks.BlockOreBasic;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;

public class BlockMod
{
    public static Block crafting_machine_idle;
    public static Block crafting_machine_active;
    public static Block adamantium_ore;
    public static Block adamantium_block;
    public static Block cobalt_ore;
    public static Block cobalt_block;
    public static Block mythril_ore;
    public static Block mythril_block;
    public static Block base_block;

    public static void init()
    {
    	crafting_machine_idle = new BlockCraftingMachine(false).setBlockName("crafting_machine_idle").setCreativeTab(LymbowMod.tabLymbow).setHardness(3.5F);
    	crafting_machine_active = new BlockCraftingMachine(true).setBlockName("crafting_machine_active").setHardness(3.5F);
        cobalt_ore = new BlockOreBasic().setBlockName("cobalt_ore").setCreativeTab(CreativeTabs.tabBlock).setBlockTextureName(Reference.MOD_ID + ":CobaltOre");
        cobalt_block = new BlockBasic(Material.iron).setBlockName("cobalt_block").setCreativeTab(CreativeTabs.tabBlock).setBlockTextureName(Reference.MOD_ID + ":CobaltBlock");
        mythril_ore = new BlockOreBasic().setBlockName("mythril_ore").setCreativeTab(CreativeTabs.tabBlock).setBlockTextureName(Reference.MOD_ID + ":MythrilOre");
        mythril_block = new BlockBasic(Material.iron).setBlockName("mythril_block").setCreativeTab(CreativeTabs.tabBlock).setBlockTextureName(Reference.MOD_ID + ":MythrilBlock");
        adamantium_ore = new BlockOreBasic().setBlockName("adamantium_ore").setCreativeTab(CreativeTabs.tabBlock).setBlockTextureName(Reference.MOD_ID + ":AdamantiumOre");
        adamantium_block = new BlockBasic(Material.iron).setBlockName("adamantium_block").setCreativeTab(CreativeTabs.tabBlock).setBlockTextureName(Reference.MOD_ID + ":AdamantiumBlock");
        base_block = new BaseFinderBlock();
    }

    public static void register()
    {
        GameRegistry.registerBlock(crafting_machine_idle, "crafting_machine_idle");
        GameRegistry.registerBlock(crafting_machine_active, "crafting_machine_active");
        GameRegistry.registerBlock(cobalt_block, "cobalt_block");
        GameRegistry.registerBlock(adamantium_ore, "adamantium_ore");
        GameRegistry.registerBlock(adamantium_block, "adamantium_block");
        GameRegistry.registerBlock(mythril_ore, "mythril_ore");
        GameRegistry.registerBlock(mythril_block, "mythril_block");
        GameRegistry.registerBlock(base_block, "base_block");
    }
}
