package com.lymbow.mod.handler;

import com.lymbow.mod.container.ContainerCraftingMachine;
import com.lymbow.mod.gui.GuiCraftingMachine;
import com.lymbow.mod.init.OtherInit;
import com.lymbow.mod.tileentity.TileEntityCraftingMachine;

import cpw.mods.fml.common.network.IGuiHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class GuiHandler implements IGuiHandler {

	@Override
	public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
		TileEntity entity = world.getTileEntity(x, y, z);
		
		if(entity != null) {
			switch(ID) {
			case OtherInit.gui_id_crafting_machine:
				if (entity instanceof TileEntityCraftingMachine) {
					return new ContainerCraftingMachine(player.inventory, (TileEntityCraftingMachine) entity);
				}
				return null;
			}
		}
		return null;
	}

	@Override
	public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
		TileEntity entity = world.getTileEntity(x, y, z);
		
		if(entity != null) {
			switch(ID) {
			case OtherInit.gui_id_crafting_machine:
				if (entity instanceof TileEntityCraftingMachine) {
					return new GuiCraftingMachine(player.inventory, (TileEntityCraftingMachine) entity);
				}
				return null;
			}
		}
		return null;
	}

}
