package com.lymbow.mod.gui;

import org.lwjgl.opengl.GL11;

import com.lymbow.mod.Reference;
import com.lymbow.mod.container.ContainerCraftingMachine;
import com.lymbow.mod.tileentity.TileEntityCraftingMachine;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;

public class GuiCraftingMachine extends GuiContainer {
	
	private ResourceLocation texture = new ResourceLocation(Reference.MOD_ID + ":" + "textures/gui/GuiCraftingMachine.png");
	private TileEntityCraftingMachine craftingMachine;

	public GuiCraftingMachine(InventoryPlayer invPlayer, TileEntityCraftingMachine teCraftingMachine) {
		super(new ContainerCraftingMachine(invPlayer, teCraftingMachine));
		craftingMachine = teCraftingMachine;

		this.xSize = 176;
		this.ySize = 166;
	}

	protected void drawGuiContainerForegroundLayer(int i, int j) {
		String name = this.craftingMachine.hasCustomInventoryName() ? this.craftingMachine.getInventoryName() : I18n.format(this.craftingMachine.getInventoryName());
		
		this.fontRendererObj.drawString(name, this.xSize / 2 - this.fontRendererObj.getStringWidth(name) / 2, 6, 4210752);
		this.fontRendererObj.drawString(I18n.format("container.inventory"), 8, this.ySize - 96 + 5, 4210752);
	}
	
	@Override
	protected void drawGuiContainerBackgroundLayer(float var1, int var2, int var3) {
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		Minecraft.getMinecraft().getTextureManager().bindTexture(texture);
		drawTexturedModalRect(guiLeft, guiTop, 0, 0, xSize, ySize);
		
		// do the thing with the power
		
		// do the thing with the mashing
		
	}

}
