package com.lymbow.mod.events;

import com.lymbow.mod.init.ItemMod;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.BlockOre;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;

import java.util.Random;

public class BlockEventHandler
{
    public static final Random RAND = new Random();

    @SubscribeEvent
    public void onBreak(BlockEvent.BreakEvent e)
    {
        EntityPlayer player = e.getPlayer();
        if (player.getHeldItem() != null && !player.capabilities.isCreativeMode && player.getHeldItem().getItem() == ItemMod.adamantium_hammer)
        {
            World world = e.world;

            if (!world.isRemote)
            {
                int random = RAND.nextInt(10);

                if (e.block instanceof BlockOre)
                {
                    e.setCanceled(true);
                    world.setBlockToAir(e.x, e.y, e.z);

                    int count = 1;

                    if (random >= 9)
                    {
                        count = 3;
                    }
                    else if (random >= 8)
                    {
                        count = 2;
                    }
                    else
                    {
                        count = 1;
                    }

                    Item drop = e.block.getItemDropped(0, RAND, 0);
                    ItemStack stackDrop = new ItemStack(drop, count);

                    if (drop instanceof ItemBlock)
                    {
                        stackDrop = new ItemStack(drop, count, e.blockMetadata);
                        ItemStack smelt = FurnaceRecipes.smelting().getSmeltingResult(new ItemStack(e.block, 1, e.blockMetadata));

                        if (smelt != null)
                        {
                            stackDrop = new ItemStack(smelt.getItem(), smelt.stackSize * count, smelt.getItemDamage());
                        }
                    }

                    EntityItem item = new EntityItem(world, e.x + 0.5D, e.y + 0.5D, e.z + 0.5D, stackDrop);
                    item.delayBeforeCanPickup = 10;
                    world.spawnEntityInWorld(item);
                }
            }
        }
    }
}