package com.lymbow.mod.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class EntityGrenade extends EntityThrowable
{

    public EntityGrenade(World world)
    {
        super(world);
    }

    public EntityGrenade(World world, EntityPlayer entity)
    {
        super(world, entity);
    }

    @Override
    protected void onImpact(MovingObjectPosition var1)
    {
        if (!this.worldObj.isRemote)
        {
            if (var1.typeOfHit != MovingObjectPosition.MovingObjectType.ENTITY)
            {
                this.setDead();
            	this.worldObj.createExplosion((Entity) null, this.posX, this.posY, this.posZ, 1.8F, true);
            }
        }
    }

}
