package com.lymbow.mod.container;

import com.lymbow.mod.slot.SlotCraftingMachine;
import com.lymbow.mod.tileentity.TileEntityCraftingMachine;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;

public class ContainerCraftingMachine extends Container {

	private TileEntityCraftingMachine machine;
	private int dualCookTime;
	private int dualPower;
	private int lastItemBurnTime;
	
	public ContainerCraftingMachine(InventoryPlayer invPlayer, TileEntityCraftingMachine teCraftingMachine) {
		dualCookTime = 0;
		dualPower = 0;
		lastItemBurnTime = 0;
		
		machine = teCraftingMachine;

		this.addSlotToContainer(new Slot(teCraftingMachine, 0, 41, 13));
		this.addSlotToContainer(new Slot(teCraftingMachine, 1, 41, 52));
		this.addSlotToContainer(new Slot(teCraftingMachine, 2, 8, 56));
		this.addSlotToContainer(new SlotCraftingMachine(invPlayer.player, teCraftingMachine, 3, 113, 33));
		
		
		//Inventory
		for(int i = 0; i < 3; i++) {
			for(int j = 0; i < 9; j++) {
				this.addSlotToContainer(new Slot(invPlayer, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
			}
		}
		
		//ActionBar
		for(int i = 0; i < 9; i++) {
			this.addSlotToContainer(new Slot(invPlayer, i, 8 + i * 18, 142));
		}
	}
	
	@Override
	public boolean canInteractWith(EntityPlayer player) {
		return machine.isUseableByPlayer(player);
	}

}
