package com.lymbow.mod;

import com.lymbow.mod.entity.TMEntity;
import com.lymbow.mod.events.BlockEventHandler;
import com.lymbow.mod.handler.GuiHandler;
import com.lymbow.mod.init.BlockMod;
import com.lymbow.mod.init.RecipesMod;
import com.lymbow.mod.items.ItemObsidianBreakerLymbowMod;
import com.lymbow.mod.init.ItemMod;
import com.lymbow.mod.proxy.CommonProxy;
import com.lymbow.mod.world.WorldGeneration;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.EventHandler;
import cpw.mods.fml.common.Mod.Instance;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid = Reference.MOD_ID, name = Reference.MOD_NAME, version = Reference.VERSION)
public class LymbowMod
{
	WorldGeneration worldgeneration = new WorldGeneration();
	
    @Instance(Reference.MOD_ID)
    public static LymbowMod modInstance;

    @SidedProxy(clientSide = Reference.CLIENT_PROXY, serverSide = Reference.SERVER_PROXY)
    public static CommonProxy proxy;

    public static CreativeTabs tabLymbow = new CreativeTabs("tabLymbow")
    {
        @SideOnly(Side.CLIENT)
        public Item getTabIconItem()
        {
            return Item.getItemFromBlock(BlockMod.adamantium_block);
        }
    };

    @EventHandler
    public void preInit(FMLPreInitializationEvent event)
    {
        BlockMod.init();
        BlockMod.register();
        ItemMod.init();
        ItemMod.register();
        RecipesMod.register();
        GameRegistry.registerWorldGenerator(worldgeneration, 0);
        TMEntity.mainRegistry();
    }

    @EventHandler
    public void init(FMLInitializationEvent event)
    {
    	NetworkRegistry.INSTANCE.registerGuiHandler(this, new GuiHandler());
        proxy.registerRenders();
        proxy.registerTileEntities();
        proxy.registerRenderThings();
        MinecraftForge.EVENT_BUS.register(new BlockEventHandler());
    }

    @EventHandler
    public void postInit(FMLPostInitializationEvent event)
    {

    }
}