package com.spyman.mechanicalcraft.common.world;

import com.spyman.mechanicalcraft.common.MechanicalCraft;
import com.spyman.mechanicalcraft.common.blocks.MechanicalCraftBlocks;
import com.spyman.mechanicalcraft.common.items.MechanicalCraftItems;
import cpw.mods.fml.common.IWorldGenerator;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;

import java.util.Random;

public class WorldGeneration implements IWorldGenerator
{
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider)
    {
        switch(world.provider.dimensionId)
        {

            case -1:
                generateNether(world, random, chunkX * 16, chunkZ * 16);
                break;

            case 0:
                generateSurface(world, random, chunkX * 16, chunkZ * 16);
                break;

            case 1:
                generateEnd(world, random, chunkX * 16, chunkZ * 16);
                break;
        }
    }

     // this.addOreSpawn(block, metadata, replace block, world, random, x, z, 16, 16, maxOreSize, rarity, Y min, Y max);

    private void generateEnd(World world, Random random, int x, int z)
    {

    }

    private void generateSurface(World world, Random random, int x, int z)
    {
        this.addOreSpawn(MechanicalCraftBlocks.copperOre, 0, Blocks.stone, world, random, x, z, 16, 16, 8, 20, 7, 256);
        this.addOreSpawn(MechanicalCraftBlocks.tinOre,    0, Blocks.stone, world, random, x, z, 16, 16, 8, 20, 7, 256);
        this.addOreSpawn(MechanicalCraftBlocks.zincOre,   0, Blocks.stone, world, random, x, z, 16, 16, 8,  20, 7, 256);
        this.addOreSpawn(MechanicalCraftBlocks.sulfurOre, 0, Blocks.stone, world, random, x, z, 16, 16, 4,  20, 5, 40);

        // -------------------------------------------------

        int x1 = x + random.nextInt(16);
        int y1 = random.nextInt(128);
        int z1 = z + random.nextInt(16);

        for (int i = 0; i < 500; i++)
        {
            if (world.getBiomeGenForCoords(x1, z1) == BiomeGenBase.forest)
            {
                (new FactoryGen()).generate(world, random, x1, y1, z1);
            }
        }
    }

    private void generateNether(World world, Random random, int x, int z)
    {

    }

    public void addOreSpawn(Block block, int metadata, Block target, World world, Random random, int blockXPos, int blockZPos, int maxX, int maxZ, int maxVeinSize, int chancesToSpawn, int minY, int maxY)
    {
        assert maxY > minY :            "Ymax >>> Ymin";
        assert maxX > 0 && maxX <= 16 : "0 < X < 16";
        assert minY > 0 :               "Y >>> 0";
        assert maxY < 256 && maxY > 0 : "0 < Y < 256";
        assert maxZ > 0 && maxZ <= 16 : "0 < Z < 16";

        for(int i = 0; i < chancesToSpawn; i++)
        {
            int posY = random.nextInt(128);

            if((posY <= maxY) && (posY >= minY))
            {
                (new WorldGenMinable(block, metadata, maxVeinSize, target)).generate(world, random, blockXPos + random.nextInt(16), posY, blockZPos + random.nextInt(16));
            }
        }
    }
}
