package com.spyman.mechanicalcraft.common.tileentity;

import com.spyman.mechanicalcraft.common.blocks.MechanicalCraftBlocks;
import com.spyman.mechanicalcraft.common.items.MechanicalCraftItems;
import com.spyman.mechanicalcraft.common.recipe.OreExtractorRecipes;
import com.spyman.mechanicalcraft.common.items.SpeedUpgrade;
import com.spyman.mechanicalcraft.common.items.SpeedUpgradeThree;
import com.spyman.mechanicalcraft.common.items.SpeedUpgradeTwo;
import com.spyman.mechanicalcraft.common.MechanicalCraft;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;

public class TileEntityOreExtractor extends TileEntity implements IInventory
{
    private byte direction;
    /** Slots list */
    private ItemStack[] slotResult = new ItemStack[15];
    /** Actual working time */
    public int workingTime = 0;
    /** Working time for one recipes */
    public int workingTimeNeeded = 200;
    /** Working time default value for one recipes */
    public int workingTimeNeededDefault = 200;
    /** Actual burn time */
    public int burnTime = 0;
    /** Burn time of fuel */
    public int burnTimeTotal = 0;
    /** Id of the result slot */
    private int slotResultID = 3;
    /** Id of the upgrade slot */
    private int slotUpgradeID = 2;
    /** Id of the fuel slot */
    private int slotFuelID = 1;
    /** Id of the input slot */
    private int slotInputID = 0;

    @Override
    public void readFromNBT(NBTTagCompound compound)
    {
        super.readFromNBT(compound);
        this.direction = compound.getByte("Direction");
        NBTTagList nbttaglist = compound.getTagList("MechanicalCraftItems", 10);
        this.slotResult = new ItemStack[this.getSizeInventory()];

        for(int i = 0; i < nbttaglist.tagCount(); ++i)
        {
            NBTTagCompound nbtTagCompound = nbttaglist.getCompoundTagAt(i);
            int j = nbtTagCompound.getByte("Slot") & 255;

            if(j >= 0 && j < this.slotResult.length)
            {
                this.slotResult[j] = ItemStack.loadItemStackFromNBT(nbtTagCompound);
            }
        }
        this.workingTime = compound.getShort("workingTime");
        this.burnTime = compound.getShort("burnTime");
        this.burnTimeTotal = compound.getShort("burnTimeTotal");
    }

    @Override
    public void writeToNBT(NBTTagCompound compound)
    {
        super.writeToNBT(compound);
        NBTTagList nbttaglist = new NBTTagList();
        compound.setByte("Direction", this.direction);
        for(int i = 0; i < this.slotResult.length; ++i)
        {
            if(this.slotResult[i] != null)
            {
                NBTTagCompound nbtTagCompound = new NBTTagCompound();
                nbtTagCompound.setByte("Slot", (byte)i);
                this.slotResult[i].writeToNBT(nbtTagCompound);
                nbttaglist.appendTag(nbtTagCompound);

            }
        }
        compound.setTag("MechanicalCraftItems", nbttaglist);
        compound.setShort("workingTime", (short)this.workingTime);
        compound.setShort("burnTime", (short)this.burnTime);
        compound.setShort("burnTimeTotal", (short)this.burnTimeTotal);
    }

    public byte getDirection()
    {
        return direction;
    }

    public void setDirection(byte direction)
    {
        this.direction = direction;
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
    }

    public Packet getDescriptionPacket()
    {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.writeToNBT(nbtTagCompound);
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 0, nbtTagCompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt)
    {
        this.readFromNBT(pkt.func_148857_g());
    }

    public int getSizeInventory()
    {
        return this.slotResult.length;
    }

    public void openInventory() {}

    public void closeInventory() {}

    public String getInventoryName()
    {
        return MechanicalCraftBlocks.oreExtractor.getLocalizedName();
    }

    public boolean hasCustomInventoryName()
    {
        return false;
    }

    public int getInventoryStackLimit()
    {
        return 64;
    }

    public boolean isUseableByPlayer(EntityPlayer player)
    {
        return this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) != this ? false : player.getDistanceSq((double)this.xCoord + 0.5D, (double)this.yCoord + 0.5D, (double)this.zCoord + 0.5D) <= 64.0D;
    }

    public ItemStack getStackInSlot(int slotIndex)
    {
        return this.slotResult[slotIndex];
    }

    public ItemStack decrStackSize(int slotIndex, int amount)
    {
        if(this.slotResult[slotIndex] != null)
        {
            ItemStack itemstack;

            if(this.slotResult[slotIndex].stackSize <= amount)
            {
                itemstack = this.slotResult[slotIndex];
                this.slotResult[slotIndex] = null;
                this.markDirty();
                return itemstack;
            }
            else
            {
                itemstack = this.slotResult[slotIndex].splitStack(amount);

                if(this.slotResult[slotIndex].stackSize == 0)
                {
                    this.slotResult[slotIndex] = null;
                }
                this.markDirty();
                return itemstack;
            }
        }
        else
        {
            return null;
        }
    }

    public ItemStack getStackInSlotOnClosing(int slotIndex)
    {
        if(this.slotResult[slotIndex] != null)
        {
            ItemStack itemstack = this.slotResult[slotIndex];
            this.slotResult[slotIndex] = null;
            return itemstack;
        }
        else
        {
            return null;
        }
    }

    public void setInventorySlotContents(int slotIndex, ItemStack stack)
    {
        this.slotResult[slotIndex] = stack;

        if(stack != null && stack.stackSize > this.getInventoryStackLimit())
        {
            stack.stackSize = this.getInventoryStackLimit();
        }
        this.markDirty();
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack)
    {
        return slot == 2 ? false : true;
    }

    public boolean isBurning()
    {
        return this.workingTime > 0;
    }

    protected boolean canSmelt()
    {
        if(this.slotResult[this.slotInputID] == null)
        {
            return false;
        }
        else
        {
            ItemStack itemstack = OreExtractorRecipes.smelting().getSmeltingResult(new ItemStack[] { this.slotResult[this.slotInputID] });

             for (int i = 3; i < 15; i++)
            {
                if (this.slotResult[i] != null)
                {
                    int result = slotResult[i].stackSize + itemstack.stackSize;

                    if (this.slotResult[i].isItemEqual(itemstack))
                    {
                        return true;
                    }
                }
                else
                {
                    return true;
                }
            }
            return false;
        }
    }

    public void smeltItem()
    {
        ItemStack itemstack = OreExtractorRecipes.smelting().getSmeltingResult(new ItemStack[] { this.slotResult[this.slotInputID] });

        for (int i = 3; i < 15; i++)
        {
            if (this.canSmelt())
            {
                if (this.slotResult[i] == null)
                {
                    this.slotResult[i] = itemstack.copy();
                    return;
                }

                if (this.slotResult[i].getItem() == itemstack.getItem())
                {
                    this.slotResult[i].stackSize += itemstack.stackSize;
                    return;
                }
                this.decrStackSize(0, 1);
            }
        }
    }

    public void updateEntity()
    {
        if(this.burnTime > 0)
        {
            burnTime--;
        }
        if(this.canSmelt())
        {
            if(this.burnTime <= 0)
            {
                int time = TileEntityFurnace.getItemBurnTime(slotResult[this.slotFuelID]);

                if (time > 0)
                {
                    this.decrStackSize(1, 1);
                    this.burnTimeTotal = time;
                    this.burnTime = time;
                }
            }

            if(burnTime > 0)
            {
                workingTime++;
            }
        }
        if (this.workingTime >= this.workingTimeNeeded)
        {
            this.smeltItem();
            this.workingTime = 0;
        }
        if (!this.canSmelt() || burnTime <= 0)
        {
            this.workingTime = 0;
        }

        // Update WorkingTime --> Speed Upgrade

        if (slotResult[this.slotUpgradeID] != null)
        {
            if (slotResult[this.slotUpgradeID].getItem() == MechanicalCraftItems.speedUpgrade)
            {
                workingTimeNeeded = SpeedUpgrade.getSpeedUp();
            }
            else if (slotResult[this.slotUpgradeID].getItem() == MechanicalCraftItems.speedUpgradeTwo)
            {
                workingTimeNeeded = SpeedUpgradeTwo.getSpeedUp();
            }
            else if (slotResult[this.slotUpgradeID].getItem() == MechanicalCraftItems.speedUpgradeThree)
            {
                workingTimeNeeded = SpeedUpgradeThree.getSpeedUp();
            }
        }
        else
        {
            workingTimeNeeded = workingTimeNeededDefault;
        }
    }

    @SideOnly(Side.CLIENT)
    public int getCookProgress()
    {
        return this.workingTime * 24 / this.workingTimeNeeded;
    }

    @SideOnly(Side.CLIENT)
    public int getBurnTime()
    {
        return this.burnTime * 14 / this.burnTimeTotal;
    }
}
