package com.spyman.mechanicalcraft.common.tileentity;

import com.spyman.mechanicalcraft.common.blocks.MechanicalCraftBlocks;
import com.spyman.mechanicalcraft.common.items.MechanicalCraftItems;
import com.spyman.mechanicalcraft.common.recipe.MetalCompressorRecipes;
import com.spyman.mechanicalcraft.common.items.SpeedUpgrade;
import com.spyman.mechanicalcraft.common.items.SpeedUpgradeThree;
import com.spyman.mechanicalcraft.common.items.SpeedUpgradeTwo;
import com.spyman.mechanicalcraft.common.MechanicalCraft;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;

public class TileEntityMetalCompressor extends TileEntity implements IInventory
{
    private byte direction;
    private ItemStack[] contents = new ItemStack[5];
    public int workingTime = 0;
    public int workingTimeNeeded = 200;
    public int workingTimeNeededDefault = 200;
    public int burnTime = 0;
    public int burnTimeTotal = 0;

    @Override
    public void readFromNBT(NBTTagCompound compound)
    {
        super.readFromNBT(compound);
        this.direction = compound.getByte("Direction");
        NBTTagList nbttaglist = compound.getTagList("MechanicalCraftItems", 10);
        this.contents = new ItemStack[this.getSizeInventory()];

        for(int i = 0; i < nbttaglist.tagCount(); ++i)
        {
            NBTTagCompound nbttagcompound1 = nbttaglist.getCompoundTagAt(i);
            int j = nbttagcompound1.getByte("Slot") & 255;

            if(j >= 0 && j < this.contents.length)
            {
                this.contents[j] = ItemStack.loadItemStackFromNBT(nbttagcompound1);
            }
        }
        this.workingTime = compound.getShort("workingTime");
        this.burnTime = compound.getShort("burnTime");
        this.burnTimeTotal = compound.getShort("burnTimeTotal");
        //this.workingTimeNeeded = compound.getShort("workingTimeNeeded");
    }

    @Override
    public void writeToNBT(NBTTagCompound compound)
    {
        super.writeToNBT(compound);
        NBTTagList nbttaglist = new NBTTagList();
        compound.setByte("Direction", this.direction);
        for(int i = 0; i < this.contents.length; ++i)
        {
            if(this.contents[i] != null)
            {
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.setByte("Slot", (byte)i);
                this.contents[i].writeToNBT(nbttagcompound1);
                nbttaglist.appendTag(nbttagcompound1);
            }
        }
        compound.setTag("MechanicalCraftItems", nbttaglist);
        compound.setShort("workingTime", (short)this.workingTime);
        compound.setShort("burnTime", (short)this.burnTime);
        compound.setShort("burnTimeTotal", (short)this.burnTimeTotal);
        //compound.setShort("workingTimeNeeded", (short)this.workingTimeNeeded);
    }

    public byte getDirection()
    {
        return direction;
    }

    public void setDirection(byte direction)
    {
        this.direction = direction;
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
    }

    public Packet getDescriptionPacket()
    {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeToNBT(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 0, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt)
    {
        this.readFromNBT(pkt.func_148857_g());
    }

    public int getSizeInventory()
    {
        return this.contents.length;
    }

    public void openInventory() {}

    public void closeInventory() {}

    public String getInventoryName()
    {
        return MechanicalCraftBlocks.metalCompressor.getLocalizedName();
    }

    public boolean hasCustomInventoryName()
    {
        return false;
    }

    public int getInventoryStackLimit()
    {
        return 64;
    }

    public boolean isUseableByPlayer(EntityPlayer player)
    {
        return this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) != this ? false : player.getDistanceSq((double)this.xCoord + 0.5D, (double)this.yCoord + 0.5D, (double)this.zCoord + 0.5D) <= 64.0D;
    }

    public ItemStack getStackInSlot(int slotIndex)
    {
        return this.contents[slotIndex];
    }

    public ItemStack decrStackSize(int slotIndex, int amount)
    {
        if(this.contents[slotIndex] != null)
        {
            ItemStack itemstack;

            if(this.contents[slotIndex].stackSize <= amount)
            {
                itemstack = this.contents[slotIndex];
                this.contents[slotIndex] = null;
                this.markDirty();
                return itemstack;
            }
            else
            {
                itemstack = this.contents[slotIndex].splitStack(amount);

                if(this.contents[slotIndex].stackSize == 0)
                {
                    this.contents[slotIndex] = null;
                }
                this.markDirty();
                return itemstack;
            }
        }
        else
        {
            return null;
        }
    }

    public ItemStack getStackInSlotOnClosing(int slotIndex)
    {
        if(this.contents[slotIndex] != null)
        {
            ItemStack itemstack = this.contents[slotIndex];
            this.contents[slotIndex] = null;
            return itemstack;
        }
        else
        {
            return null;
        }
    }

    public void setInventorySlotContents(int slotIndex, ItemStack stack)
    {
        this.contents[slotIndex] = stack;

        if(stack != null && stack.stackSize > this.getInventoryStackLimit())
        {
            stack.stackSize = this.getInventoryStackLimit();
        }
        this.markDirty();
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack)
    {
        return slot == 2 ? false : true;
    }

    public boolean isBurning()
    {
        return this.workingTime > 0;
    }

    protected boolean canSmelt()
    {
        if(this.contents[0] == null)
        {
            return false;
        }
        else
        {
            ItemStack itemstack = MetalCompressorRecipes.smelting().getSmeltingResult(new ItemStack[] {this.contents[0]});
            if(itemstack == null)
                return false;
            if(this.contents[2] == null)
                return true;
            if(!this.contents[2].isItemEqual(itemstack))
                return false;
            int result = contents[2].stackSize + itemstack.stackSize;
            return result <= getInventoryStackLimit() && result <= this.contents[2].getMaxStackSize();
        }
    }

    public void smeltItem()
    {
        if(this.canSmelt())
        {
            ItemStack itemstack = MetalCompressorRecipes.smelting().getSmeltingResult(new ItemStack[] {this.contents[0]});
            if(this.contents[2] == null)
            {
                this.contents[2] = itemstack.copy();
            }
            else if(this.contents[2].getItem() == itemstack.getItem())
            {
                this.contents[2].stackSize += itemstack.stackSize;
            }

            this.decrStackSize(0, 1);
        }
    }

    public void updateEntity()
    {
        if(this.burnTime > 0)
        {
            burnTime--;
        }
        if(this.canSmelt())
        {
            if(this.burnTime <= 0)
            {
                int time = TileEntityFurnace.getItemBurnTime(contents[1]);
                if (time > 0)
                {
                    this.decrStackSize(1, 1);
                    this.burnTimeTotal = time;
                    this.burnTime = time;
                }

            }
            if(burnTime > 0)
            {
                workingTime++;
            }
        }
        if (this.workingTime >= this.workingTimeNeeded)
        {
            this.smeltItem();
            this.workingTime = 0;
        }
        if (!this.canSmelt() || burnTime <= 0)
        {
            this.workingTime = 0;
        }

        // Update WorkingTime --> Speed Upgrade

        if (contents[3] != null)
        {
            if (contents[3].getItem() == MechanicalCraftItems.speedUpgrade)
            {
                workingTimeNeeded = SpeedUpgrade.getSpeedUp();
            }
            else if (contents[3].getItem() == MechanicalCraftItems.speedUpgradeTwo)
            {
                workingTimeNeeded = SpeedUpgradeTwo.getSpeedUp();
            }
            else if (contents[3].getItem() == MechanicalCraftItems.speedUpgradeThree)
            {
                workingTimeNeeded = SpeedUpgradeThree.getSpeedUp();
            }
        }
        else
        {
            workingTimeNeeded = workingTimeNeededDefault;
        }
    }

    @SideOnly(Side.CLIENT)
    public int getCookProgress()
    {
        return this.workingTime * 24 / this.workingTimeNeeded;
    }

    @SideOnly(Side.CLIENT)
    public int getBurnTime()
    {
        return this.burnTime * 14 / this.burnTimeTotal;
    }
}
