package com.spyman.mechanicalcraft.common.recipe;

import com.spyman.mechanicalcraft.common.MechanicalCraft;
import com.spyman.mechanicalcraft.common.items.MechanicalCraftItems;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MetalCompressorRecipes
{
    public static final MetalCompressorRecipes smeltingBase = new MetalCompressorRecipes();
    private Map<ItemStack[], ItemStack> smeltingList = new HashMap<ItemStack[], ItemStack>();

    public MetalCompressorRecipes()
    {
        this.addRecipe(MechanicalCraftItems.copperIngot, new ItemStack(MechanicalCraftItems.copperPlate, 2, 0));
        this.addRecipe(MechanicalCraftItems.tinIngot, new ItemStack(MechanicalCraftItems.tinPlate, 2, 0));
        this.addRecipe(Items.iron_ingot, new ItemStack(MechanicalCraftItems.ironPlate, 2, 0));
        this.addRecipe(MechanicalCraftItems.steelIngot, new ItemStack(MechanicalCraftItems.steelPlate, 2, 0));
        this.addRecipe(Items.gold_ingot, new ItemStack(MechanicalCraftItems.goldPlate, 2, 0));
        this.addRecipe(MechanicalCraftItems.zincIngot, new ItemStack(MechanicalCraftItems.zincPlate, 2, 0));
        this.addRecipe(MechanicalCraftItems.copperPlate, new ItemStack(MechanicalCraftItems.copperCable, 8, 0));
        this.addRecipe(MechanicalCraftItems.tinPlate, new ItemStack(MechanicalCraftItems.tinCable, 8, 0));
    }

    public void addRecipe(ItemStack input1, ItemStack output1)
    {
        ItemStack[] stackList = new ItemStack[] {input1};
        this.smeltingList.put(stackList, output1);
    }

    public void addRecipe(Item input1, ItemStack output1)
    {   this.addRecipe(new ItemStack(input1), output1);   }

    public void addRecipe(Block input1, ItemStack output1)
    {   this.addRecipe(new ItemStack(input1), output1);   }

    public ItemStack getSmeltingResult(ItemStack[] stack)
    {
        Iterator<Map.Entry<ItemStack[], ItemStack>> iterator = this.smeltingList.entrySet().iterator();
        Map.Entry<ItemStack[], ItemStack> entry;

        do
        {
            if(!iterator.hasNext())
            {
                return null;
            }
            entry = (Map.Entry<ItemStack[], ItemStack>)iterator.next();
        }
        while(!this.isSameKey(stack, (ItemStack[])entry.getKey()));

        return (ItemStack)entry.getValue();
    }

    private boolean isSameKey(ItemStack[] stackList, ItemStack[] stackList2)
    {
        boolean isSame = false;

        if(stackList[0].getItem() == stackList2[0].getItem())
        {
            isSame = true;
        }
        else
        {
            return false;
        }
        return isSame;
    }

    public Map<ItemStack[], ItemStack> getSmeltingList()
    {
        return this.smeltingList;
    }

    public static MetalCompressorRecipes smelting()
    {
        return smeltingBase;
    }
}
