package com.spyman.mechanicalcraft.common.recipe;

import com.spyman.mechanicalcraft.common.MechanicalCraft;
import com.spyman.mechanicalcraft.common.blocks.MechanicalCraftBlocks;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import com.spyman.mechanicalcraft.common.items.*;

public class MechanicalCraftRecipes
{
    /**
     * This method call all recipes types methods
     */
    public void loadRecipes()
    {
        this.smeltingRecipes();
        this.craftRecipes();
    }

    /**
     * Recipes in furnace only.
     */
    public void smeltingRecipes()
    {
        GameRegistry.addSmelting(new ItemStack(MechanicalCraftItems.ironDust, 1, 0), new ItemStack(Items.iron_ingot, 1, 0), 0.3F);
        GameRegistry.addSmelting(new ItemStack(MechanicalCraftItems.steelDust, 1, 0), new ItemStack(MechanicalCraftItems.steelIngot, 1, 0), 0.3F);
        GameRegistry.addSmelting(new ItemStack(MechanicalCraftItems.copperDust, 1, 0), new ItemStack(MechanicalCraftItems.copperIngot, 1, 0), 0.3F);
        GameRegistry.addSmelting(new ItemStack(MechanicalCraftItems.goldDust, 1, 0), new ItemStack(Items.gold_ingot, 1, 0), 0.3F);
        GameRegistry.addSmelting(new ItemStack(MechanicalCraftItems.tinDust, 1, 0), new ItemStack(MechanicalCraftItems.tinIngot, 1, 0), 0.3F);
        GameRegistry.addSmelting(new ItemStack(MechanicalCraftBlocks.tinOre, 1, 0), new ItemStack(MechanicalCraftItems.tinIngot, 1, 0), 0.3F);
        GameRegistry.addSmelting(new ItemStack(MechanicalCraftBlocks.copperOre, 1, 0), new ItemStack(MechanicalCraftItems.copperIngot, 1, 0), 0.3F);
        GameRegistry.addSmelting(new ItemStack(MechanicalCraftBlocks.zincOre, 1, 0), new ItemStack(MechanicalCraftItems.zincIngot, 1, 0), 0.3F);
        GameRegistry.addSmelting(new ItemStack(MechanicalCraftItems.zincDust, 1, 0), new ItemStack(MechanicalCraftItems.zincIngot, 1, 0), 0.3F);
    }

    /**
     * Recipes in crafting table only.
     */
    public void craftRecipes()
    {
        GameRegistry.addRecipe(new ShapedOreRecipe(new ItemStack(MechanicalCraftItems.tinGear, 1, 0), new Object[]
                {
                        "0I0",
                        "III",
                        "0I0",
                        'I', "ingotTin"
                }));
        GameRegistry.addRecipe(new ShapedOreRecipe(new ItemStack(MechanicalCraftItems.steelGear, 1, 0), new Object[]
                {
                        "0I0",
                        "III",
                        "0I0",
                        'I', "ingotSteel"
                }));
        GameRegistry.addRecipe(new ShapedOreRecipe(new ItemStack(MechanicalCraftItems.copperGear, 1, 0), new Object[]
                {
                        "0I0",
                        "III",
                        "0I0",
                        'I', "ingotCopper"
                }));
        GameRegistry.addRecipe(new ItemStack(MechanicalCraftItems.ironGear, 1, 0), new Object[]
                {
                        "0I0",
                        "III",
                        "0I0",
                        'I', new ItemStack(Items.iron_ingot, 1, 0)
                });
        GameRegistry.addRecipe(new ItemStack(MechanicalCraftItems.electronicChipset, 1, 0), new Object[]
                {
                        "CPC",
                        "CRC",
                        "CPC",
                        'C', new ItemStack(MechanicalCraftItems.tinCable, 1, 0),
                        'P', new ItemStack(MechanicalCraftItems.ironPlate, 1, 0),
                        'R', new ItemStack(MechanicalCraftItems.redstoneCrystal, 1, 0)
                });
        GameRegistry.addRecipe(new ItemStack(MechanicalCraftItems.electronicGoldChipset, 1, 0), new Object[]
                {
                        "CPC",
                        "CRC",
                        "CPC",
                        'C', new ItemStack(MechanicalCraftItems.copperCable, 1, 0),
                        'P', new ItemStack(MechanicalCraftItems.goldPlate, 1, 0),
                        'R', new ItemStack(MechanicalCraftItems.redstoneCrystal, 1, 0)
                });
        GameRegistry.addRecipe(new ItemStack(MechanicalCraftItems.redstoneCrystal, 1, 0), new Object[]
                {
                        "RRR",
                        "RER",
                        "RRR",
                        'R', new ItemStack(Items.redstone, 1, 0),
                        'E', new ItemStack(Items.diamond, 1, 0)
                });
        GameRegistry.addShapelessRecipe(new ItemStack(MechanicalCraftItems.copperCable, 6, 0), new Object[]
                {
                        new ItemStack(MechanicalCraftItems.copperPlate, 1, 0),
                        new ItemStack(MechanicalCraftItems.pliers, 1, OreDictionary.WILDCARD_VALUE)
                });
        GameRegistry.addShapelessRecipe(new ItemStack(MechanicalCraftItems.tinCable, 6, 0), new Object[]
                {
                        new ItemStack(MechanicalCraftItems.tinPlate, 1, 0),
                        new ItemStack(MechanicalCraftItems.pliers, 1, OreDictionary.WILDCARD_VALUE)
                });
        GameRegistry.addShapelessRecipe(new ItemStack(MechanicalCraftItems.copperPlate, 1, 0), new Object[]
                {
                        new ItemStack(MechanicalCraftItems.copperIngot, 1, 0),
                        new ItemStack(MechanicalCraftItems.hammer, 1, OreDictionary.WILDCARD_VALUE)
                });
        GameRegistry.addRecipe(new ShapelessOreRecipe(new ItemStack(MechanicalCraftItems.tinPlate, 1, 0), new Object[]
                {
                        "ingotTin",
                        new ItemStack(MechanicalCraftItems.hammer, 1, OreDictionary.WILDCARD_VALUE)
                }));
        GameRegistry.addShapelessRecipe(new ItemStack(MechanicalCraftItems.ironPlate, 1, 0), new Object[]
                {
                        new ItemStack(Items.iron_ingot, 1, 0),
                        new ItemStack(MechanicalCraftItems.hammer, 1, OreDictionary.WILDCARD_VALUE)
                });
        GameRegistry.addRecipe(new ShapelessOreRecipe(new ItemStack(MechanicalCraftItems.steelPlate, 1, 0), new Object[]
                {
                        "ingotSteel",
                        new ItemStack(MechanicalCraftItems.hammer, 1, OreDictionary.WILDCARD_VALUE)
                }));
        GameRegistry.addShapelessRecipe(new ItemStack(MechanicalCraftItems.goldPlate, 1, 0), new Object[]
                {
                        new ItemStack(Items.gold_ingot, 1, 0),
                        new ItemStack(MechanicalCraftItems.hammer, 1, OreDictionary.WILDCARD_VALUE)
                });
        GameRegistry.addRecipe(new ShapelessOreRecipe(new ItemStack(MechanicalCraftItems.zincPlate, 1, 0), new Object[]
                {
                        "ingotZinc",
                        new ItemStack(MechanicalCraftItems.hammer, 1, OreDictionary.WILDCARD_VALUE)
                }));
        GameRegistry.addRecipe(new ItemStack(MechanicalCraftItems.coil, 1, 0), new Object[]
                {
                        "RRR",
                        "RER",
                        "RRR",
                        'R', new ItemStack(MechanicalCraftItems.copperCable, 1, 0),
                        'E', new ItemStack(Items.iron_ingot, 1, 0)
                });
        GameRegistry.addRecipe(new ItemStack(MechanicalCraftItems.pliers, 1, 0), new Object[]
                {
                        "I0I",
                        "0I0",
                        "I0I",
                        'I', new ItemStack(Items.iron_ingot, 1, 0)
                });
        GameRegistry.addRecipe(new ShapedOreRecipe(new ItemStack(MechanicalCraftItems.wrench, 1, 0), new Object[]
                {
                        "I0I",
                        "III",
                        "0I0",
                        'I', "ingotBronze"
                }));
        GameRegistry.addRecipe(new ItemStack(MechanicalCraftItems.hammer, 1, 0), new Object[]
                {
                        "III",
                        "III",
                        "0S0",
                        'I', new ItemStack(Items.iron_ingot, 1, 0),
                        'S', new ItemStack(Items.stick, 1, 0)
                });
        GameRegistry.addRecipe(new ItemStack(MechanicalCraftItems.electricMotor, 1, 0), new Object[]
                {
                        "CTT",
                        "TOI",
                        "CTT",
                        'C', new ItemStack(MechanicalCraftItems.copperCable, 1, 0),
                        'I', new ItemStack(Items.iron_ingot, 1, 0),
                        'T', new ItemStack(MechanicalCraftItems.tinPlate, 1, 0),
                        'O', new ItemStack(MechanicalCraftItems.coil, 1, 0)
                });



        GameRegistry.addRecipe(new ItemStack(MechanicalCraftItems.redstoneDrill, 1, 0), new Object[]
                {
                        "SRR",
                        "SER",
                        "GSS",
                        'R', new ItemStack(MechanicalCraftItems.redstoneCrystal, 1, 0),
                        'E', new ItemStack(MechanicalCraftItems.electricalEngine, 1, 0),
                        'S', new ItemStack(MechanicalCraftItems.steelPlate, 1, 0),
                        'G', new ItemStack(MechanicalCraftItems.electronicGoldChipset, 1, 0)
                });
        GameRegistry.addRecipe(new ShapedOreRecipe(new ItemStack(MechanicalCraftBlocks.crusher, 1, 0), new Object[]
                {
                        "IEI",
                        "CMG",
                        "IEI",
                        'M', new ItemStack(MechanicalCraftBlocks.machineBlock, 1, 0),
                        'E', new ItemStack(MechanicalCraftItems.engine, 1, 0),
                        'I', new ItemStack(MechanicalCraftItems.ironPlate, 1, 0),
                        'G', "gearIron",
                        'C', new ItemStack(MechanicalCraftItems.crusherBlade, 1, 0)
                }));
        GameRegistry.addRecipe(new ShapedOreRecipe(new ItemStack(MechanicalCraftBlocks.metalCompressor, 1, 0), new Object[]
                {
                        "IEI",
                        "GMG",
                        "IEI",
                        'M', new ItemStack(MechanicalCraftBlocks.machineBlock, 1, 0),
                        'E', new ItemStack(MechanicalCraftItems.engine, 1, 0),
                        'I', new ItemStack(MechanicalCraftItems.ironPlate, 1, 0),
                        'G', "gearIron"
                }));
        GameRegistry.addRecipe(new ItemStack(MechanicalCraftBlocks.alloyer, 1, 0), new Object[]
                {
                        "IEI",
                        "FMF",
                        "IEI",
                        'M', new ItemStack(MechanicalCraftBlocks.machineBlock, 1, 0),
                        'E', new ItemStack(MechanicalCraftItems.engine, 1, 0),
                        'I', new ItemStack(MechanicalCraftItems.ironPlate, 1, 0),
                        'F', new ItemStack(MechanicalCraftBlocks.ironFurnace, 1, 0)
                });
        GameRegistry.addRecipe(new ItemStack(MechanicalCraftBlocks.ironFurnace, 1, 0), new Object[]
                {
                        "IEI",
                        "FMF",
                        "IEI",
                        'M', new ItemStack(MechanicalCraftBlocks.machineBlock, 1, 0),
                        'E', new ItemStack(MechanicalCraftItems.engine, 1, 0),
                        'I', new ItemStack(MechanicalCraftItems.ironPlate, 1, 0),
                        'F', new ItemStack(Blocks.furnace, 1, 0)
                });
        GameRegistry.addRecipe(new ItemStack(MechanicalCraftBlocks.oreExtractor, 1, 0), new Object[]
                {
                        "IEI",
                        "CMC",
                        "IEI",
                        'M', new ItemStack(MechanicalCraftBlocks.machineBlock, 1, 0),
                        'E', new ItemStack(MechanicalCraftItems.engine, 1, 0),
                        'I', new ItemStack(MechanicalCraftItems.ironPlate, 1, 0),
                        'C', new ItemStack(MechanicalCraftItems.crusherBlade, 1, 0)
                });
        GameRegistry.addRecipe(new ItemStack(MechanicalCraftBlocks.machineBlock, 1, 0), new Object[]
                {
                        "SSS",
                        "SIS",
                        "SSS",
                        'I', new ItemStack(Items.iron_ingot, 1, 0),
                        'S', new ItemStack(MechanicalCraftItems.ironPlate, 1, 0)
                });
        GameRegistry.addRecipe(new ShapedOreRecipe(new ItemStack(MechanicalCraftItems.electricalEngine, 1, 0), new Object[]
                {
                        "SMS",
                        "GEG",
                        "SMS",
                        'M', new ItemStack(MechanicalCraftItems.electricMotor, 1, 0),
                        'E', new ItemStack(MechanicalCraftItems.engine, 1, 0),
                        'S', new ItemStack(MechanicalCraftItems.steelPlate, 1, 0),
                        'G', "gearSteel"
                }));
        GameRegistry.addRecipe(new ShapedOreRecipe(new ItemStack(MechanicalCraftItems.engine, 1, 0), new Object[]
                {
                        "IGI",
                        "GFG",
                        "IGI",
                        'G', "gearIron",
                        'I', new ItemStack(MechanicalCraftItems.ironPlate, 1, 0),
                        'F', new ItemStack(Blocks.furnace, 1, 0)
                }));
        GameRegistry.addRecipe(new ItemStack(MechanicalCraftItems.crusherBlade, 1, 0), new Object[]
                {
                        "0D0",
                        "DID",
                        "0D0",
                        'D', new ItemStack(Items.diamond, 1, 0),
                        'I', new ItemStack(Items.iron_ingot, 1, 0)
                });
        GameRegistry.addShapelessRecipe(new ItemStack(MechanicalCraftItems.redstoneDrill, 1, 0), new Object[]
                {
                        new ItemStack(MechanicalCraftItems.battery, 1, OreDictionary.WILDCARD_VALUE),
                        new ItemStack(MechanicalCraftItems.redstoneDrill, 1, OreDictionary.WILDCARD_VALUE)
                });
        GameRegistry.addShapelessRecipe(new ItemStack(MechanicalCraftItems.redstoneChainsaw, 1, 0), new Object[]
                {
                        new ItemStack(MechanicalCraftItems.battery, 1, OreDictionary.WILDCARD_VALUE),
                        new ItemStack(MechanicalCraftItems.redstoneChainsaw, 1, OreDictionary.WILDCARD_VALUE)
                });
        GameRegistry.addRecipe(new ShapedOreRecipe(new ItemStack(MechanicalCraftItems.speedUpgrade, 1, 0), new Object[]
                {
                        "CCC",
                        "CPC",
                        "CCC",
                        'C', new ItemStack(MechanicalCraftItems.copperPlate, 1, 0),
                        'P', "gearCopper"
                }));
        GameRegistry.addRecipe(new ShapedOreRecipe(new ItemStack(MechanicalCraftItems.speedUpgradeTwo, 1, 0), new Object[]
                {
                        "UPU",
                        "PGP",
                        "UPU",
                        'U', new ItemStack(MechanicalCraftItems.speedUpgrade, 1, 0),
                        'G', "gearIron",
                        'P', new ItemStack(MechanicalCraftItems.ironPlate, 1, 0)
                }));
        GameRegistry.addRecipe(new ShapedOreRecipe(new ItemStack(MechanicalCraftItems.speedUpgradeThree, 1, 0), new Object[]
                {
                        "UPU",
                        "PGP",
                        "UPU",
                        'U', new ItemStack(MechanicalCraftItems.speedUpgradeTwo, 1, 0),
                        'G', "gearSteel",
                        'P', new ItemStack(MechanicalCraftItems.steelPlate, 1, 0)
                }));
        GameRegistry.addRecipe(new ShapedOreRecipe(new ItemStack(MechanicalCraftItems.sulfuricAcid, 3, 0), new Object[]
                {
                        "SWS",
                        "SWS",
                        "SWS",
                        'S', "dustSulfur",
                        'W', new ItemStack(Items.water_bucket, 1, 0)
                }));
        GameRegistry.addRecipe(new ItemStack(MechanicalCraftItems.battery, 1, 0), new Object[]
                {
                        "PCP",
                        "PAP",
                        "PAP",
                        'P', new ItemStack(MechanicalCraftItems.zincPlate, 1, 0),
                        'A', new ItemStack(MechanicalCraftItems.sulfuricAcid, 1, 0),
                        'C', new ItemStack(MechanicalCraftItems.copperCable, 1, 0)
                });
        GameRegistry.addRecipe(new ShapedOreRecipe(new ItemStack(MechanicalCraftBlocks.tinBlock, 1, 0), new Object[]
                {
                        "CCC",
                        "CCC",
                        "CCC",
                        'C', "ingotTin"
                }));
        GameRegistry.addRecipe(new ShapedOreRecipe(new ItemStack(MechanicalCraftBlocks.copperBlock, 1, 0), new Object[]
                {
                        "CCC",
                        "CCC",
                        "CCC",
                        'C', "ingotCopper"
                }));
        GameRegistry.addRecipe(new ShapedOreRecipe(new ItemStack(MechanicalCraftBlocks.zincBlock, 1, 0), new Object[]
                {
                        "CCC",
                        "CCC",
                        "CCC",
                        'C', "ingotZinc"
                }));
        GameRegistry.addRecipe(new ShapedOreRecipe(new ItemStack(MechanicalCraftBlocks.steelBlock, 1, 0), new Object[]
                {
                        "CCC",
                        "CCC",
                        "CCC",
                        'C', "ingotSteel"
                }));
        GameRegistry.addRecipe(new ShapedOreRecipe(new ItemStack(MechanicalCraftBlocks.bronzeBlock, 1, 0), new Object[]
                {
                        "CCC",
                        "CCC",
                        "CCC",
                        'C', "ingotBronze"
                }));
        GameRegistry.addShapelessRecipe(new ItemStack(MechanicalCraftItems.tinIngot, 9, 0), new Object[]
                {
                        new ItemStack(MechanicalCraftBlocks.tinBlock, 1, 0)
                });
        GameRegistry.addShapelessRecipe(new ItemStack(MechanicalCraftItems.copperIngot, 9, 0), new Object[]
                {
                        new ItemStack(MechanicalCraftBlocks.copperBlock, 1, 0)
                });
        GameRegistry.addShapelessRecipe(new ItemStack(MechanicalCraftItems.zincIngot, 9, 0), new Object[]
                {
                        new ItemStack(MechanicalCraftBlocks.zincBlock, 1, 0)
                });
        GameRegistry.addShapelessRecipe(new ItemStack(MechanicalCraftItems.steelIngot, 9, 0), new Object[]
                {
                        new ItemStack(MechanicalCraftBlocks.steelBlock, 1, 0)
                });
        GameRegistry.addShapelessRecipe(new ItemStack(MechanicalCraftItems.bronzeIngot, 9, 0), new Object[]
                {
                        new ItemStack(MechanicalCraftBlocks.bronzeBlock, 1, 0)
                });
        GameRegistry.addRecipe(new ShapedOreRecipe(new ItemStack(MechanicalCraftItems.steelPickaxe, 1, 0), new Object[]
                {
                        "SSS",
                        "0T0",
                        "0T0",
                        'S', "ingotSteel",
                        'T', new ItemStack(Items.stick, 1, 0)
                }));
        GameRegistry.addRecipe(new ShapedOreRecipe(new ItemStack(MechanicalCraftItems.bronzePickaxe, 1, 0), new Object[]
                {
                        "SSS",
                        "0T0",
                        "0T0",
                        'S', "ingotBronze",
                        'T', new ItemStack(Items.stick, 1, 0)
                }));
        GameRegistry.addRecipe(new ShapedOreRecipe(new ItemStack(MechanicalCraftItems.steelAxe, 1, 0), new Object[]
                {
                        "SS",
                        "ST",
                        "0T",
                        'S', "ingotSteel",
                        'T', new ItemStack(Items.stick, 1, 0)
                }));
        GameRegistry.addRecipe(new ShapedOreRecipe(new ItemStack(MechanicalCraftItems.bronzeAxe, 1, 0), new Object[]
                {
                        "SS",
                        "ST",
                        "0T",
                        'S', "ingotBronze",
                        'T', new ItemStack(Items.stick, 1, 0)
                }));
        GameRegistry.addRecipe(new ShapedOreRecipe(new ItemStack(MechanicalCraftItems.steelShovel, 1, 0), new Object[]
                {
                        "S",
                        "T",
                        "T",
                        'S', "ingotSteel",
                        'T', new ItemStack(Items.stick, 1, 0)
                }));
        GameRegistry.addRecipe(new ShapedOreRecipe(new ItemStack(MechanicalCraftItems.bronzeShovel, 1, 0), new Object[]
                {
                        "S",
                        "T",
                        "T",
                        'S', "ingotBronze",
                        'T', new ItemStack(Items.stick, 1, 0)
                }));
        GameRegistry.addRecipe(new ShapedOreRecipe(new ItemStack(MechanicalCraftItems.steelSword, 1, 0), new Object[]
                {
                        "S",
                        "S",
                        "T",
                        'S', "ingotSteel",
                        'T', new ItemStack(Items.stick, 1, 0)
                }));
        GameRegistry.addRecipe(new ShapedOreRecipe(new ItemStack(MechanicalCraftItems.bronzeSword, 1, 0), new Object[]
                {
                        "S",
                        "S",
                        "T",
                        'S', "ingotBronze",
                        'T', new ItemStack(Items.stick, 1, 0)
                }));
        GameRegistry.addRecipe(new ShapedOreRecipe(new ItemStack(MechanicalCraftItems.steelHoe, 1, 0), new Object[]
                {
                        "SS",
                        "0T",
                        "0T",
                        'S', "ingotSteel",
                        'T', new ItemStack(Items.stick, 1, 0)
                }));
        GameRegistry.addRecipe(new ShapedOreRecipe(new ItemStack(MechanicalCraftItems.bronzeHoe, 1, 0), new Object[]
                {
                        "SS",
                        "0T",
                        "0T",
                        'S', "ingotBronze",
                        'T', new ItemStack(Items.stick, 1, 0)
                }));
        GameRegistry.addRecipe(new ShapedOreRecipe(new ItemStack(MechanicalCraftItems.bronzeHelmet, 1, 0), new Object[]
                {
                        "CCC",
                        "C0C",
                        'C', "ingotBronze"
                }));
        GameRegistry.addRecipe(new ShapedOreRecipe(new ItemStack(MechanicalCraftItems.bronzeChestplate, 1, 0), new Object[]
                {
                        "C0C",
                        "CCC",
                        "CCC",
                        'C', "ingotBronze"
                }));
        GameRegistry.addRecipe(new ShapedOreRecipe(new ItemStack(MechanicalCraftItems.bronzeLeggings, 1, 0), new Object[]
                {
                        "CCC",
                        "C0C",
                        "C0C",
                        'C', "ingotBronze"
                }));
        GameRegistry.addRecipe(new ShapedOreRecipe(new ItemStack(MechanicalCraftItems.bronzeBoots, 1, 0), new Object[]
                {
                        "C0C",
                        "C0C",
                        'C', "ingotBronze"
                }));
        GameRegistry.addRecipe(new ShapedOreRecipe(new ItemStack(MechanicalCraftItems.steelHelmet, 1, 0), new Object[]
                {
                        "CCC",
                        "C0C",
                        'C', "ingotSteel"
                }));
        GameRegistry.addRecipe(new ShapedOreRecipe(new ItemStack(MechanicalCraftItems.steelChestplate, 1, 0), new Object[]
                {
                        "C0C",
                        "CCC",
                        "CCC",
                        'C', "ingotSteel"
                }));
        GameRegistry.addRecipe(new ShapedOreRecipe(new ItemStack(MechanicalCraftItems.steelLeggings, 1, 0), new Object[]
                {
                        "CCC",
                        "C0C",
                        "C0C",
                        'C', "ingotSteel"
                }));
        GameRegistry.addRecipe(new ShapedOreRecipe(new ItemStack(MechanicalCraftItems.steelBoots, 1, 0), new Object[]
                {
                        "C0C",
                        "C0C",
                        'C', "ingotSteel"
                }));
    }
}
