package com.spyman.mechanicalcraft.common.recipe;

import com.spyman.mechanicalcraft.common.MechanicalCraft;
import com.spyman.mechanicalcraft.common.blocks.MechanicalCraftBlocks;
import com.spyman.mechanicalcraft.common.items.MechanicalCraftItems;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CrusherRecipes
{
    public static CrusherRecipes smeltingBase = new CrusherRecipes();
    private Map<ItemStack[], ItemStack> smeltingList = new HashMap<ItemStack[], ItemStack>();

    public CrusherRecipes()
    {
        this.addRecipe(MechanicalCraftItems.copperIngot, new ItemStack(MechanicalCraftItems.copperDust, 1, 0));
        this.addRecipe(MechanicalCraftItems.steelIngot, new ItemStack(MechanicalCraftItems.steelDust, 1, 0));
        this.addRecipe(MechanicalCraftItems.tinIngot, new ItemStack(MechanicalCraftItems.tinDust, 1, 0));
        this.addRecipe(Items.iron_ingot, new ItemStack(MechanicalCraftItems.ironDust, 1, 0));
        this.addRecipe(Items.gold_ingot, new ItemStack(MechanicalCraftItems.goldDust, 1, 0));
        this.addRecipe(Items.coal, new ItemStack(MechanicalCraftItems.coalDust, 1, 0));
        this.addRecipe(MechanicalCraftItems.bronzeIngot, new ItemStack(MechanicalCraftItems.bronzeDust, 1, 0));
        this.addRecipe(MechanicalCraftItems.brokenCoalOre, new ItemStack(Items.coal, 2, 0));
        this.addRecipe(Blocks.coal_ore, new ItemStack(Items.coal, 2, 0));
        this.addRecipe(MechanicalCraftItems.brokenIronOre, new ItemStack(MechanicalCraftItems.ironDust, 2, 0));
        this.addRecipe(Blocks.iron_ore, new ItemStack(MechanicalCraftItems.ironDust, 2, 0));
        this.addRecipe(MechanicalCraftItems.brokenGoldOre, new ItemStack(MechanicalCraftItems.goldDust, 2, 0));
        this.addRecipe(Blocks.gold_ore, new ItemStack(MechanicalCraftItems.goldDust, 2, 0));
        this.addRecipe(MechanicalCraftItems.brokenCopperOre, new ItemStack(MechanicalCraftItems.copperDust, 2, 0));
        this.addRecipe(MechanicalCraftBlocks.copperOre, new ItemStack(MechanicalCraftItems.copperDust, 2, 0));
        this.addRecipe(MechanicalCraftItems.brokenTinOre, new ItemStack(MechanicalCraftItems.tinDust, 2, 0));
        this.addRecipe(MechanicalCraftBlocks.tinOre, new ItemStack(MechanicalCraftItems.tinDust, 2, 0));
        this.addRecipe(MechanicalCraftItems.brokenEmeraldOre, new ItemStack(Items.emerald, 2, 0));
        this.addRecipe(Blocks.emerald_ore, new ItemStack(Items.emerald, 2, 0));
        this.addRecipe(MechanicalCraftItems.brokenDiamondOre, new ItemStack(Items.diamond, 2, 0));
        this.addRecipe(Blocks.diamond_ore, new ItemStack(Items.diamond, 2, 0));
        this.addRecipe(MechanicalCraftItems.brokenRedstoneOre, new ItemStack(Items.redstone, 8, 0));
        this.addRecipe(Blocks.redstone_ore, new ItemStack(Items.redstone, 8, 0));
        this.addRecipe(MechanicalCraftItems.brokenLapisOre, new ItemStack(Items.dye, 8, 4));
        this.addRecipe(Blocks.lapis_ore, new ItemStack(Items.dye, 8, 4));
        this.addRecipe(MechanicalCraftBlocks.zincOre, new ItemStack(MechanicalCraftItems.zincDust, 2, 0));
        this.addRecipe(MechanicalCraftItems.zincIngot, new ItemStack(MechanicalCraftItems.zincDust, 1, 0));
        this.addRecipe(MechanicalCraftItems.brokenZincOre, new ItemStack(MechanicalCraftItems.zincDust, 2, 0));
        this.addRecipe(Blocks.cobblestone, new ItemStack(Blocks.gravel, 1, 0));
        this.addRecipe(Blocks.gravel, new ItemStack(Blocks.sand, 1, 0));
    }

    public void addRecipe(ItemStack input1, ItemStack output1)
    {
        ItemStack[] stackList = new ItemStack[] {input1};
        this.smeltingList.put(stackList, output1);
    }

    public void addRecipe(Item input1, ItemStack output1)
    {   this.addRecipe(new ItemStack(input1), output1);   }

    public void addRecipe(Block input1, ItemStack output1)
    {   this.addRecipe(new ItemStack(input1), output1);   }

    public ItemStack getSmeltingResult(ItemStack[] stack)
    {
        Iterator<Map.Entry<ItemStack[], ItemStack>> iterator = this.smeltingList.entrySet().iterator();
        Map.Entry<ItemStack[], ItemStack> entry;

        do
        {
            if(!iterator.hasNext())
            {
                return null;
            }
            entry = (Map.Entry<ItemStack[], ItemStack>)iterator.next();
        }
        while(!this.isSameKey(stack, (ItemStack[])entry.getKey()));

        return (ItemStack)entry.getValue();
    }

    private boolean isSameKey(ItemStack[] stackList, ItemStack[] stackList2)
    {
        boolean isSame = false;

        if(stackList[0].getItem() == stackList2[0].getItem())
        {
            isSame = true;
        }
        else
        {
            return false;
        }
        return isSame;
    }

    public Map<ItemStack[], ItemStack> getSmeltingList()
    {
        return this.smeltingList;
    }

    public static CrusherRecipes smelting()
    {
        return smeltingBase;
    }
}
