package com.spyman.mechanicalcraft.common.recipe;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;

import com.spyman.mechanicalcraft.common.MechanicalCraft;
import com.spyman.mechanicalcraft.common.items.MechanicalCraftItems;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;


public class AlloyerRecipes
{
    public static AlloyerRecipes smeltingBase = new AlloyerRecipes();
    private Map<ItemStack[], ItemStack> smeltingList = new HashMap<ItemStack[], ItemStack>();

    public AlloyerRecipes()
    {
        this.addRecipe(MechanicalCraftItems.copperDust, MechanicalCraftItems.tinDust, new ItemStack(MechanicalCraftItems.bronzeIngot, 2, 0));
        this.addRecipe(MechanicalCraftItems.tinDust, MechanicalCraftItems.copperDust, new ItemStack(MechanicalCraftItems.bronzeIngot, 2, 0));
        this.addRecipe(MechanicalCraftItems.ironDust, MechanicalCraftItems.coalDust, new ItemStack(MechanicalCraftItems.steelIngot, 2, 0));
        this.addRecipe(MechanicalCraftItems.coalDust, MechanicalCraftItems.ironDust, new ItemStack(MechanicalCraftItems.steelIngot, 2, 0));
    }

    public void addRecipe(ItemStack input1, ItemStack input2, ItemStack output1)
    {
        ItemStack[] stackList = new ItemStack[] {input1, input2};
        this.smeltingList.put(stackList, output1);
    }

    public void addRecipe(Item input1, Item input2 ,ItemStack output1)
    {
        this.addRecipe(new ItemStack(input1), new ItemStack(input2), output1);
    }

    public ItemStack getSmeltingResult(ItemStack[] stack)
    {
        Iterator<Entry<ItemStack[], ItemStack>> iterator = this.smeltingList.entrySet().iterator();
        Entry<ItemStack[], ItemStack> entry;

        do
        {
            if(!iterator.hasNext())
            {
                return null;
            }
            entry = (Entry<ItemStack[], ItemStack>)iterator.next();
        }
        while(!this.isSameKey(stack, (ItemStack[])entry.getKey()));

        return (ItemStack)entry.getValue();
    }

    private boolean isSameKey(ItemStack[] stackList, ItemStack[] stackList2)
    {
        boolean isSame = false;
        for(int i = 0; i < 2; i++)
        {
            if(stackList[i].getItem() == stackList2[i].getItem())
            {
                isSame = true;
            }
            else
            {
                return false;
            }
        }
        return isSame;
    }

    public Map<ItemStack[], ItemStack> getSmeltingList()
    {
        return this.smeltingList;
    }

    public static AlloyerRecipes smelting()
    {
        return smeltingBase;
    }
}