package com.spyman.mechanicalcraft.common.items.tools;

import com.spyman.mechanicalcraft.common.MechanicalCraft;
import com.spyman.mechanicalcraft.common.items.MechanicalCraftItems;
import com.spyman.mechanicalcraft.common.world.FactoryGen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class StructSpawnItem extends Item
{
    public StructSpawnItem(String factotySpawn)
    {
        setUnlocalizedName(factotySpawn);
        setCreativeTab(MechanicalCraft.creatab);
        setTextureName(MechanicalCraft.TEXTURE_NAME+factotySpawn);
    }

    @Override
    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer player)
    {
        if (itemstack.getItem() == MechanicalCraftItems.factorySpawn)
        {
            int x = (int)player.posX;
            int y = (int)player.posY;
            int z = (int)player.posZ;

            FactoryGen.spawn(world, x + 1, y, z + 1);
        }
        return itemstack;
    }
}
