package com.spyman.mechanicalcraft.common.items.armors;

import com.spyman.mechanicalcraft.common.MechanicalCraft;
import com.spyman.mechanicalcraft.common.items.MechanicalCraftItems;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;

public class SteelArmor extends ItemArmor
{
    public SteelArmor(ArmorMaterial steelArmorMaterial, int type, String name)
    {
        super (steelArmorMaterial, 0 , type);
        setUnlocalizedName(name);
        setTextureName(MechanicalCraft.TEXTURE_NAME + name);
        setCreativeTab(MechanicalCraft.creatab);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type)
    {
        if(slot == 2)
        {
            return MechanicalCraft.TEXTURE_NAME + "textures/models/armor/steel_layer_2.png";
        }
        return MechanicalCraft.TEXTURE_NAME + "textures/models/armor/steel_layer_1.png";
    }

    public boolean getIsRepairable(ItemStack input, ItemStack repair)
    {
        if(repair.getItem() == MechanicalCraftItems.steelHelmet)
        {
            return true;
        }
        if(repair.getItem() == MechanicalCraftItems.steelChestplate)
        {
            return true;
        }
        if(repair.getItem() == MechanicalCraftItems.steelLeggings)
        {
            return true;
        }
        if(repair.getItem() == MechanicalCraftItems.steelBoots)
        {
            return true;
        }
        return false;
    }
}
