package com.spyman.mechanicalcraft.common.items.armors;

import com.spyman.mechanicalcraft.common.MechanicalCraft;
import com.spyman.mechanicalcraft.common.items.MechanicalCraftItems;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;

public class BronzeArmor extends ItemArmor
{
    public BronzeArmor(ArmorMaterial material, int type, String name)
    {
        super(material, 0, type);
        setUnlocalizedName(name);
        setTextureName(MechanicalCraft.TEXTURE_NAME + name);
        setCreativeTab(MechanicalCraft.creatab);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type)
    {
        if(slot == 2)
        {
            return MechanicalCraft.TEXTURE_NAME + "textures/models/armor/bronze_layer_2.png";
        }
        return MechanicalCraft.TEXTURE_NAME + "textures/models/armor/bronze_layer_1.png";
    }

    public boolean getIsRepairable(ItemStack input, ItemStack repair)
    {
        if(repair.getItem() == MechanicalCraftItems.bronzeHelmet)
        {
            return true;
        }
        if(repair.getItem() == MechanicalCraftItems.bronzeChestplate)
        {
            return true;
        }
        if(repair.getItem() == MechanicalCraftItems.bronzeLeggings)
        {
            return true;
        }
        if(repair.getItem() == MechanicalCraftItems.bronzeBoots)
        {
            return true;
        }
        return false;
    }
}
