package com.spyman.mechanicalcraft.common.items;

import com.spyman.mechanicalcraft.common.items.armors.BronzeArmor;
import com.spyman.mechanicalcraft.common.items.armors.SteelArmor;
import com.spyman.mechanicalcraft.common.items.tools.*;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.oredict.OreDictionary;

public class MechanicalCraftItems
{
    //* Items *//
    public static Item wrench, hammer, pliers;
    public static Item steelPickaxe, steelAxe, steelShovel, steelSword, steelHoe;
    public static Item redstoneDrill, redstoneChainsaw;
    public static Item bronzePickaxe, bronzeAxe, bronzeShovel, bronzeHoe, bronzeSword;
    public static Item steelIngot, copperIngot, tinIngot, bronzeIngot, zincIngot, sulfur;
    public static Item ironPlate, steelPlate, copperPlate, tinPlate, goldPlate, zincPlate;
    public static Item ironGear, steelGear, copperGear, tinGear;
    public static Item redstoneCrystal;
    public static Item battery;
    public static Item speedUpgrade, speedUpgradeTwo, speedUpgradeThree;
    public static Item steelDust, coalDust, ironDust, copperDust, tinDust, bronzeDust, goldDust, zincDust;
    public static Item engine, electricalEngine;
    public static Item crusherBlade;
    public static Item sulfuricAcid;
    public static Item tinCable, copperCable;
    public static Item electronicChipset, electronicGoldChipset, coil, electricMotor;
    public static Item brokenZincOre, brokenTinOre, brokenCopperOre, brokenIronOre, brokenCoalOre, brokenGoldOre, brokenRedstoneOre, brokenDiamondOre, brokenEmeraldOre, brokenLapisOre;
    public static Item factorySpawn;
    public static Item steelHelmet, steelChestplate, steelLeggings, steelBoots;
    public static Item bronzeHelmet, bronzeChestplate, bronzeLeggings, bronzeBoots;
    //* Tool material *//
    public static Item.ToolMaterial steelTools = EnumHelper.addToolMaterial("SteelTools", 2, 649, 10.0F, 3.0F, 20);
    public static Item.ToolMaterial bronzeTools = EnumHelper.addToolMaterial("BronzeTools", 2, 315, 9.0F, 2.0F, 18);
    public static Item.ToolMaterial redTools = EnumHelper.addToolMaterial("pickaxe", 5, 999, 14.0F, 6.0F, 0);
    //* Armor material *//
    public static ItemArmor.ArmorMaterial bronzeArmorMaterial = EnumHelper.addArmorMaterial("bronzeArmorMaterial", 15, new int[]{2, 6, 5, 2}, 9);
    public static ItemArmor.ArmorMaterial steelArmorMaterial = EnumHelper.addArmorMaterial("steelArmorMaterial", 33, new int[]{3, 8, 6, 3}, 10);

    /**
     * This method load all items.
     */
    public void loadItems()
    {
        brokenTinOre = new BrokenOres("brokenTinOre");
        brokenCopperOre = new BrokenOres("brokenCopperOre");
        brokenIronOre = new BrokenOres("brokenIronOre");
        brokenCoalOre = new BrokenOres("brokenCoalOre");
        brokenGoldOre = new BrokenOres("brokenGoldOre");
        brokenRedstoneOre = new BrokenOres("brokenRedstoneOre");
        brokenDiamondOre = new BrokenOres("brokenDiamondOre");
        brokenEmeraldOre = new BrokenOres("brokenEmeraldOre");
        brokenLapisOre = new BrokenOres("brokenLapisOre");
        brokenZincOre = new BrokenOres("brokenZincOre");

        steelDust = new ItemsDusts("steelDust");
        coalDust = new ItemsDusts("coalDust");
        ironDust = new ItemsDusts("ironDust");
        copperDust = new ItemsDusts("copperDust");
        tinDust = new ItemsDusts("tinDust");
        bronzeDust = new ItemsDusts("bronzeDust");
        goldDust = new ItemsDusts("goldDust");
        zincDust = new ItemsDusts("zincDust");

        ironPlate = new ItemsPlates("ironPlate");
        steelPlate = new ItemsPlates("steelPlate");
        copperPlate = new ItemsPlates("copperPlate");
        tinPlate = new ItemsPlates("tinPlate");
        goldPlate = new ItemsPlates("goldPlate");
        zincPlate = new ItemsPlates("zincPlate");

        copperCable = new ItemsCables("copperCable");
        tinCable = new ItemsCables("tinCable");

        electronicChipset = new ElectricComposants("electronicChipset");
        electronicGoldChipset = new ElectricComposants("electronicGoldChipset");
        coil = new ElectricComposants("coil");
        electricMotor = new ElectricComposants("electricMotor");
        redstoneCrystal = new ElectricComposants("redstoneCrystal");
        crusherBlade = new ElectricComposants("crusherBlade");
        battery = new Battery("battery");

        engine = new Engine("engine");
        electricalEngine = new Engine("electricalEngine");

        ironGear = new ItemsGears("ironGear");
        steelGear = new ItemsGears("steelGear");
        copperGear = new ItemsGears("copperGear");
        tinGear = new ItemsGears("tinGear");

        steelIngot = new ItemsIngots("steelIngot");
        copperIngot = new ItemsIngots("copperIngot");
        tinIngot = new ItemsIngots("tinIngot");
        bronzeIngot = new ItemsIngots("bronzeIngot");
        zincIngot = new ItemsIngots("zincIngot");
        sulfur = new ItemsIngots("sulfur");

        bronzePickaxe = new BronzePickaxe(bronzeTools, "bronzePickaxe");
        bronzeAxe = new BronzeAxe(bronzeTools, "bronzeAxe");
        bronzeShovel = new BronzeShovel(bronzeTools, "bronzeShovel");
        bronzeHoe = new BronzeHoe(bronzeTools, "bronzeHoe");
        bronzeSword = new BronzeSword(bronzeTools, "bronzeSword");

        steelPickaxe = new SteelPickaxe(steelTools, "steelPickaxe");
        steelAxe = new SteelAxe(steelTools, "steelAxe");
        steelShovel = new SteelShovel(steelTools, "steelShovel");
        steelHoe = new SteelHoe(steelTools, "steelHoe");
        steelSword = new SteelSword(steelTools, "steelSword");

        bronzeHelmet = new BronzeArmor(bronzeArmorMaterial, 0, "bronzeHelmet");
        bronzeChestplate = new BronzeArmor(bronzeArmorMaterial, 1, "bronzeChestplate");
        bronzeLeggings = new BronzeArmor(bronzeArmorMaterial, 2, "bronzeLeggings");
        bronzeBoots = new BronzeArmor(bronzeArmorMaterial, 3, "bronzeBoots");

        steelHelmet = new SteelArmor(steelArmorMaterial, 0, "steelHelmet");
        steelChestplate = new SteelArmor(steelArmorMaterial, 1, "steelChestplate");
        steelLeggings = new SteelArmor(steelArmorMaterial, 2, "steelLeggings");
        steelBoots = new SteelArmor(steelArmorMaterial, 3, "steelBoots");

        speedUpgrade = new SpeedUpgrade("speedUpgrade", 150);
        speedUpgradeTwo = new SpeedUpgradeTwo("speedUpgradeTwo", 100);
        speedUpgradeThree = new SpeedUpgradeThree("speedUpgradeThree", 50);

        sulfuricAcid = new SulfuricAcid("sulfuricAcid");

        factorySpawn = new StructSpawnItem("factorySpawn");

        redstoneDrill = new RedstoneDrill(redTools);
        redstoneChainsaw = new RedstoneChainsaw(redTools, "redstoneChainsaw");

        hammer = new Hammer();
        wrench = new Wrench();
        pliers = new Pliers();

        GameRegistry.registerItem(wrench, "Wrench");
        GameRegistry.registerItem(hammer, "Hammer");
        GameRegistry.registerItem(steelIngot, "steelIngot");
        OreDictionary.registerOre("ingotSteel", steelIngot);
        GameRegistry.registerItem(coalDust, "coalDust");
        OreDictionary.registerOre("dustCoal",coalDust);
        GameRegistry.registerItem(ironPlate, "ironPlate");
        GameRegistry.registerItem(steelPlate, "steelPlate");
        GameRegistry.registerItem(ironGear, "ironGear");
        OreDictionary.registerOre("gearIron", ironGear);
        GameRegistry.registerItem(steelGear, "steelGear");
        OreDictionary.registerOre("gearSteel", steelGear);
        GameRegistry.registerItem(steelDust, "steelDust");
        OreDictionary.registerOre("dustSteel", steelDust);
        GameRegistry.registerItem(ironDust, "ironDust");
        OreDictionary.registerOre("dustIron", ironDust);
        GameRegistry.registerItem(redstoneCrystal, "redstoneCrystal");
        GameRegistry.registerItem(engine, "Engine");
        GameRegistry.registerItem(pliers, "Pliers");
        GameRegistry.registerItem(copperIngot, "copperIngot");
        OreDictionary.registerOre("ingotCopper", copperIngot);
        GameRegistry.registerItem(copperDust, "copperDust");
        OreDictionary.registerOre("dustCopper", copperDust);
        GameRegistry.registerItem(copperGear, "copperGear");
        OreDictionary.registerOre("gearCopper", copperGear);
        GameRegistry.registerItem(copperPlate, "copperPlate");
        GameRegistry.registerItem(crusherBlade, "crusherBlade");
        GameRegistry.registerItem(steelPickaxe, "SteelPickaxe");
        GameRegistry.registerItem(steelAxe, "SteelAxe");
        GameRegistry.registerItem(steelShovel, "SteelShovel");
        GameRegistry.registerItem(steelSword, "SteelSword");
        GameRegistry.registerItem(steelHoe, "SteelHoe");
        GameRegistry.registerItem(copperCable, "copperCable");
        GameRegistry.registerItem(tinCable, "tinCable");
        GameRegistry.registerItem(tinGear, "tinGear");
        OreDictionary.registerOre("gearTin", tinGear);
        GameRegistry.registerItem(tinDust, "tinDust");
        OreDictionary.registerOre("dustTin", tinDust);
        GameRegistry.registerItem(tinIngot, "tinIngot");
        OreDictionary.registerOre("ingotTin", tinIngot);
        GameRegistry.registerItem(tinPlate, "tinPlate");
        GameRegistry.registerItem(goldDust, "goldDust");
        OreDictionary.registerOre("dustGold", goldDust);
        GameRegistry.registerItem(goldPlate, "goldPlate");
        GameRegistry.registerItem(electronicChipset, "electronicChipset");
        GameRegistry.registerItem(redstoneDrill, "RedstoneDrill");
        GameRegistry.registerItem(electricalEngine, "ElectricalEngine");
        GameRegistry.registerItem(electricMotor, "ElectricMotor");
        GameRegistry.registerItem(coil, "Coil");
        GameRegistry.registerItem(electronicGoldChipset, "ElectronicGoldChipset");
        GameRegistry.registerItem(brokenLapisOre, "BrokenLapisOre");
        GameRegistry.registerItem(brokenIronOre, "BrokenIronOre");
        GameRegistry.registerItem(brokenCoalOre, "BrokenCoalOre");
        GameRegistry.registerItem(brokenRedstoneOre, "BrokenRedstoneOre");
        GameRegistry.registerItem(brokenCopperOre, "BrokenCopperOre");
        GameRegistry.registerItem(brokenTinOre, "BrokenTinOre");
        GameRegistry.registerItem(brokenDiamondOre, "BrokenDiamondOre");
        GameRegistry.registerItem(brokenEmeraldOre, "BrokenEmeraldOre");
        GameRegistry.registerItem(brokenGoldOre, "BrokenGoldOre");
        GameRegistry.registerItem(bronzeIngot, "BronzeIngot");
        OreDictionary.registerOre("ingotBronze", bronzeIngot);
        GameRegistry.registerItem(bronzeDust, "BronzeDust");
        OreDictionary.registerOre("dustBronze", bronzeDust);
        GameRegistry.registerItem(bronzeAxe, "BronzeAxe");
        GameRegistry.registerItem(bronzePickaxe, "BronzePickaxe");
        GameRegistry.registerItem(bronzeShovel, "BronzeShovel");
        GameRegistry.registerItem(bronzeHoe, "BronzeHoe");
        GameRegistry.registerItem(bronzeSword, "BronzeSword");
        GameRegistry.registerItem(battery, "battery");
        GameRegistry.registerItem(speedUpgrade, "speedUpgrade");
        GameRegistry.registerItem(speedUpgradeTwo, "speedUpgradeTwo");
        GameRegistry.registerItem(speedUpgradeThree, "speedUpgradeThree");
        GameRegistry.registerItem(sulfuricAcid, "sulfuricAcid");
        GameRegistry.registerItem(zincDust, "zincDust");
        OreDictionary.registerOre("dustZinc", zincDust);
        GameRegistry.registerItem(zincIngot, "zincIngot");
        OreDictionary.registerOre("ingotZinc", zincDust);
        GameRegistry.registerItem(sulfur, "sulfur");
        OreDictionary.registerOre("sulfur", sulfur);
        GameRegistry.registerItem(brokenZincOre, "brokenZincOre");
        GameRegistry.registerItem(zincPlate, "zincPlate");
        GameRegistry.registerItem(redstoneChainsaw, "redstoneChainsaw");
        GameRegistry.registerItem(factorySpawn, "factorySpawn");
        GameRegistry.registerItem(steelHelmet, "steelHelmet");
        GameRegistry.registerItem(steelChestplate, "steelChestplate");
        GameRegistry.registerItem(steelLeggings, "steelLeggings");
        GameRegistry.registerItem(steelBoots, "steelBoots");
        GameRegistry.registerItem(bronzeHelmet, "bronzeHelmet");
        GameRegistry.registerItem(bronzeChestplate, "bronzeChestplate");
        GameRegistry.registerItem(bronzeLeggings, "bronzeLeggings");
        GameRegistry.registerItem(bronzeBoots, "bronzeBoots");
    }
}
