package com.spyman.mechanicalcraft.common.items;

import com.spyman.mechanicalcraft.common.MechanicalCraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class Battery extends Item
{
    public Battery(String battery)
    {
        setUnlocalizedName(battery);
        setTextureName(MechanicalCraft.TEXTURE_NAME+battery);
        setCreativeTab(MechanicalCraft.creatab);
        setMaxDamage(4);
        setMaxStackSize(16);
    }

    public ItemStack getContainerItem(ItemStack itemStack)
    {
        return new ItemStack(this, 1, itemStack.getItemDamage() + 1);
    }

    public boolean hasContainerItem(ItemStack stack)
    {
        return true;
    }

    public boolean doesContainerItemLeaveCraftingGrid(ItemStack stack)
    {
        return false;
    }
}
