package com.spyman.mechanicalcraft.common.gui;

import com.spyman.mechanicalcraft.common.MechanicalCraft;
import com.spyman.mechanicalcraft.common.container.ContainerOreExtractor;
import com.spyman.mechanicalcraft.common.tileentity.TileEntityOreExtractor;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiOreExtractor extends GuiContainer
{
    private static final ResourceLocation texture = new ResourceLocation(MechanicalCraft.MOD_ID,"textures/gui/container/GuiOreExtractor.png");
    private TileEntityOreExtractor tileOreExtractor;
    private IInventory playerInv;
    private int xSize1 = 106;
    private int ySize1 = 30;

    /*
     * y : height
     * x : width
     */

    public GuiOreExtractor(TileEntityOreExtractor tile, InventoryPlayer inventory)
    {
        super(new ContainerOreExtractor(tile, inventory));
        this.tileOreExtractor = tile;
        this.playerInv = inventory;
        this.allowUserInput = false;
        this.ySize = 166;
        this.xSize = 176;
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float p_146976_1_, int p_146976_2_, int p_146976_3_)
    {
        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
        this.mc.getTextureManager().bindTexture(texture);
        int k = (this.width - this.xSize) / 2;
        int l = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(k, l, 0, 0, this.xSize, this.ySize);
        // Orange layer
        this.drawTexturedModalRect(k - xSize1, l + ySize1, 0, 166, xSize1, ySize1);
        // Blue layer
        this.drawTexturedModalRect(k - xSize1, l + ((2 * ySize1) + 2), 0, 196, xSize1, ySize1);

        if(this.tileOreExtractor.isBurning())
        {
            /*  this.drawTexturedModalRect(x, y, u, v, width, height)
             *  -----------------------------------------------------
             *  x: X position --> on GUI
             *  y: Y position --> on GUI
             *  u: X position --> on texture
             *  v: Y position --> on texture
             *  width: WIDTH of a texture part
             *  height: HEIGHT of a texture part
             */
            int i = this.tileOreExtractor.getCookProgress();
            this.drawTexturedModalRect(k + 31, l + 35, 176, 14, i + 1, 16);
        }
        if (tileOreExtractor.burnTimeTotal > 0 && tileOreExtractor.getBurnTime() > 0)
        {
            int p = this.tileOreExtractor.getBurnTime();
            this.drawTexturedModalRect(k + 9, l + 37 + (14 - p), 176, 14 - p, 14, p);
        }
    }

    protected void drawGuiContainerForegroundLayer(int x, int y)
    {
        String s = this.tileOreExtractor.hasCustomInventoryName() ? this.tileOreExtractor.getInventoryName() : I18n.format(this.tileOreExtractor.getInventoryName(), new Object[0]);
        this.fontRendererObj.drawString(s, this.xSize / 2 - this.fontRendererObj.getStringWidth(s) / 2, 6, 4210752);
        this.fontRendererObj.drawString(this.playerInv.hasCustomInventoryName() ? this.playerInv.getInventoryName() : I18n.format(this.playerInv.getInventoryName()), 9, 73, 4210752);
        this.fontRendererObj.drawString(tileOreExtractor.burnTime + "/" + tileOreExtractor.burnTimeTotal, -76, 41, 4210752);
        this.fontRendererObj.drawString((100 * tileOreExtractor.workingTime / tileOreExtractor.workingTimeNeeded) + "%", 32, 57, 4210752);
        this.fontRendererObj.drawString((tileOreExtractor.workingTimeNeeded + "/t"), -76, 73, 4210752);

    }
}
