package com.spyman.mechanicalcraft.common.gui;

import com.spyman.mechanicalcraft.common.MechanicalCraft;
import com.spyman.mechanicalcraft.common.container.ContainerMetalCompressor;
import com.spyman.mechanicalcraft.common.tileentity.TileEntityMetalCompressor;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiMetalCompressor extends GuiContainer
{
    private static final ResourceLocation texture = new ResourceLocation(MechanicalCraft.MOD_ID,"textures/gui/container/GuiMetalCompressor.png");

    private TileEntityMetalCompressor tileMetalCompressor;
    private IInventory playerInv;
    private int xSize1 = 106;
    private int ySize1 = 30;

    /*
     * y : height
     * x : width
     */

    public GuiMetalCompressor(TileEntityMetalCompressor tile, InventoryPlayer inventory)
    {
        super(new ContainerMetalCompressor(tile, inventory));
        this.tileMetalCompressor = tile;
        this.playerInv = inventory;
        this.allowUserInput = false;
        this.ySize = 166;
        this.xSize = 176;
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float p_146976_1_, int p_146976_2_, int p_146976_3_)
    {
        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
        this.mc.getTextureManager().bindTexture(texture);
        int k = (this.width - this.xSize) / 2;
        int l = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(k, l, 0, 0, this.xSize, this.ySize);
        // Orange layer
        this.drawTexturedModalRect(k - xSize1, l + ySize1, 0, 166, xSize1, ySize1);
        // Blue layer
        this.drawTexturedModalRect(k - xSize1, l + ((2 * ySize1) + 2), 0, 196, xSize1, ySize1);

        if(this.tileMetalCompressor.isBurning())
        {
            /*  this.drawTexturedModalRect(x, y, u, v, width, height)
             *  -----------------------------------------------------
             *  x: X position --> on GUI
             *  y: Y position --> on GUI
             *  u: X position --> on texture
             *  v: Y position --> on texture
             *  width: WIDTH of a texture part
             *  height: HEIGHT of a texture part
             */
            int i = this.tileMetalCompressor.getCookProgress();
            this.drawTexturedModalRect(k + 79, l + 35, 176, 14, i + 1, 16);
        }
        if (tileMetalCompressor.burnTimeTotal > 0 && tileMetalCompressor.getBurnTime() > 0)
        {
            int p = this.tileMetalCompressor.getBurnTime();
            this.drawTexturedModalRect(k + 57, l + 36 + (14 - p), 176, 14 - p, 14, p);
        }
    }

    protected void drawGuiContainerForegroundLayer(int x, int y)
    {
        String s = this.tileMetalCompressor.hasCustomInventoryName() ? this.tileMetalCompressor.getInventoryName() : I18n.format(this.tileMetalCompressor.getInventoryName(), new Object[0]);
        this.fontRendererObj.drawString(s, this.xSize / 2 - this.fontRendererObj.getStringWidth(s) / 2, 6, 4210752);
        this.fontRendererObj.drawString(this.playerInv.hasCustomInventoryName() ? this.playerInv.getInventoryName() : I18n.format(this.playerInv.getInventoryName()), 9, 73, 4210752);
        this.fontRendererObj.drawString(tileMetalCompressor.burnTime + "/" + tileMetalCompressor.burnTimeTotal, -76, 41, 4210752);
        this.fontRendererObj.drawString((100 * tileMetalCompressor.workingTime / tileMetalCompressor.workingTimeNeeded) + "%", 80, 57, 4210752);
        this.fontRendererObj.drawString((tileMetalCompressor.workingTimeNeeded + "/t"), -76, 73, 4210752);

    }
}
