package com.spyman.mechanicalcraft.common.container;

import com.spyman.mechanicalcraft.common.container.slotresult.IronFurnaceSlotResult;
import com.spyman.mechanicalcraft.common.tileentity.TileEntityIronFurnace;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerIronFurnace extends Container
{
    private TileEntityIronFurnace tileCrusher;
    private int workingTime;
    private int workingTimeNeeded;

    public ContainerIronFurnace(TileEntityIronFurnace tile, InventoryPlayer inventory)
    {
        this.tileCrusher = tile;
        this.addSlotToContainer(new Slot((IInventory)tile, 0, 56, 17));//dust 1
        this.addSlotToContainer(new Slot((IInventory)tile, 1, 56, 53));//coal
        this.addSlotToContainer(new IronFurnaceSlotResult(tile, 2, 116, 35));//result
        this.addSlotToContainer(new Slot((IInventory)tile, 3, 150, 17));//upgrade
        this.bindPlayerInventory(inventory);
    }

    @Override
    public boolean canInteractWith(EntityPlayer player)
    {
        return this.tileCrusher.isUseableByPlayer(player);
    }

    private void bindPlayerInventory(InventoryPlayer inventory)
    {
        int i;
        for (i = 0; i < 3; ++i)
        {
            for (int j = 0; j < 9; ++j)
            {
                this.addSlotToContainer(new Slot(inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }

        for (i = 0; i < 9; ++i)
        {
            this.addSlotToContainer(new Slot(inventory, i, 8 + i * 18, 142));
        }
    }

    public ItemStack transferStackInSlot(EntityPlayer player, int quantity)
    {
        ItemStack itemstack = null;
        Slot slot = (Slot)this.inventorySlots.get(quantity);

        if (slot != null && slot.getHasStack())
        {
            ItemStack itemstack1 = slot.getStack();
            itemstack = itemstack1.copy();

            if (quantity < this.tileCrusher.getSizeInventory())
            {
                if (!this.mergeItemStack(itemstack1, this.tileCrusher.getSizeInventory(), this.inventorySlots.size(), true))
                {
                    return null;
                }
            }
            else if (!this.mergeItemStack(itemstack1, 0, this.tileCrusher.getSizeInventory(), false))
            {
                return null;
            }

            if (itemstack1.stackSize == 0)
            {
                slot.putStack((ItemStack)null);
            }
            else
            {
                slot.onSlotChanged();
            }
        }
        return itemstack;
    }
    public void onContainerClosed(EntityPlayer player)
    {
        super.onContainerClosed(player);
        this.tileCrusher.closeInventory();
    }

    public void detectAndSendChanges()
    {
        super.detectAndSendChanges();

        for(int i = 0; i < this.crafters.size(); ++i)
        {
            ICrafting icrafting = (ICrafting)this.crafters.get(i);

            if(this.workingTime != this.tileCrusher.workingTime)
            {
                icrafting.sendProgressBarUpdate(this, 0, this.tileCrusher.workingTime);
            }

            if(this.workingTimeNeeded != this.tileCrusher.workingTimeNeeded)
            {
                icrafting.sendProgressBarUpdate(this, 1, this.tileCrusher.workingTimeNeeded);
            }
        }

        this.workingTime = this.tileCrusher.workingTime;
        this.workingTimeNeeded = this.tileCrusher.workingTimeNeeded;
    }

    @SideOnly(Side.CLIENT)
    public void updateProgressBar(int id, int value)
    {
        if(id == 0)
        {
            this.tileCrusher.workingTime = value;
        }

        if(id == 1)
        {
            this.tileCrusher.workingTimeNeeded = value;
        }
    }
}
