package com.spyman.mechanicalcraft.common.blocks;

import com.spyman.mechanicalcraft.common.MechanicalCraft;
import com.spyman.mechanicalcraft.common.items.MechanicalCraftItems;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;

import java.util.Random;

public class SulfurOre extends Block
{
    public SulfurOre(Material rock)
    {
        super(rock);
        setHardness(3.0F);
        setResistance(10.0F);
        setHarvestLevel("pickaxe", 1);
        canSilkHarvest();
    }

    public Item getItemDropped(int i, Random rand, int j)
    {
        return MechanicalCraftItems.sulfur;
    }

    public int quantityDropped(Random rand)
    {
        return 2 + rand.nextInt(5);
    }

    private Random rand = new Random();

    @Override
    public int getExpDrop(IBlockAccess iblockAccess, int i, int j)
    {
        return MathHelper.getRandomIntegerInRange(rand, 0, 2);
    }
}
