package com.spyman.mechanicalcraft.common.blocks;

import com.spyman.mechanicalcraft.common.MechanicalCraft;
import com.spyman.mechanicalcraft.common.tileentity.*;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraftforge.oredict.OreDictionary;

public class MechanicalCraftBlocks
{

    public static Block crusher;
    public static Block ironFurnace;
    public static Block alloyer;
    public static Block metalCompressor;
    public static Block oreExtractor;
    public static Block machineBlock;
    public static Block tinOre, copperOre, zincOre, sulfurOre;
    public static Block tinBlock, copperBlock, zincBlock, steelBlock, bronzeBlock;

    public void loadBlocks()
    {
        crusher = new Crusher(Material.iron).setBlockName("crusher").setCreativeTab(MechanicalCraft.creatab);
        ironFurnace = new IronFurnace(Material.iron).setBlockName("furnace").setCreativeTab(MechanicalCraft.creatab);
        machineBlock = new MachineBlock(Material.iron).setCreativeTab(MechanicalCraft.creatab).setBlockName("machineBlock").setBlockTextureName(MechanicalCraft.TEXTURE_NAME + "machine_side");
        copperOre = new CopperOre(Material.rock).setBlockName("copperOre").setCreativeTab(MechanicalCraft.creatab).setBlockTextureName(MechanicalCraft.TEXTURE_NAME + "copperOre");
        tinOre = new TinOre(Material.rock).setBlockName("tinOre").setCreativeTab(MechanicalCraft.creatab).setBlockTextureName(MechanicalCraft.TEXTURE_NAME + "tinOre");
        alloyer = new Alloyer(Material.iron).setBlockName("alloyer").setCreativeTab(MechanicalCraft.creatab);
        zincOre = new ZincOre(Material.rock).setBlockName("zincOre").setCreativeTab(MechanicalCraft.creatab).setBlockTextureName(MechanicalCraft.TEXTURE_NAME + "zincOre");
        sulfurOre = new SulfurOre(Material.rock).setBlockName("sulfurOre").setCreativeTab(MechanicalCraft.creatab).setBlockTextureName(MechanicalCraft.TEXTURE_NAME + "sulfurOre");
        metalCompressor = new MetalCompressor(Material.iron).setBlockName("metalCompressor").setCreativeTab(MechanicalCraft.creatab).setBlockTextureName(MechanicalCraft.TEXTURE_NAME + "metalCompressor");
        oreExtractor = new OreExtractor(Material.iron).setBlockName("oreExtractor").setCreativeTab(MechanicalCraft.creatab).setBlockTextureName(MechanicalCraft.TEXTURE_NAME + "oreExtractor");
        tinBlock = new IngotBlock(Material.iron, "tinBlock");
        copperBlock = new IngotBlock(Material.iron, "copperBlock");
        zincBlock = new IngotBlock(Material.iron, "zincBlock");
        steelBlock = new IngotBlock(Material.iron, "steelBlock");
        bronzeBlock = new IngotBlock(Material.iron, "bronzeBlock");

        GameRegistry.registerBlock(crusher, "crusher");
        GameRegistry.registerBlock(machineBlock, "machineBlock");
        GameRegistry.registerBlock(ironFurnace, "ironFurnace");
        GameRegistry.registerBlock(copperOre, "copperOre");
        GameRegistry.registerBlock(tinOre, "tinOre");
        GameRegistry.registerBlock(alloyer, "alloyer");
        GameRegistry.registerBlock(zincOre, "zincOre");
        GameRegistry.registerBlock(sulfurOre, "sulfurOre");
        GameRegistry.registerBlock(metalCompressor, "metalCompressor");
        GameRegistry.registerBlock(tinBlock, "tinBlock");
        OreDictionary.registerOre("blockTin", tinBlock);
        GameRegistry.registerBlock(copperBlock, "copperBlock");
        OreDictionary.registerOre("blockCopper", copperBlock);
        GameRegistry.registerBlock(zincBlock, "zincBlock");
        OreDictionary.registerOre("blockZinc", zincBlock);
        GameRegistry.registerBlock(steelBlock, "steelBlock");
        OreDictionary.registerOre("blockSteel", steelBlock);
        GameRegistry.registerBlock(bronzeBlock, "bronzeBlock");
        OreDictionary.registerOre("blockBronze", bronzeBlock);
        GameRegistry.registerBlock(oreExtractor, "oreExtractor");

        GameRegistry.registerTileEntity(TileEntityCrusher.class, "mechanicalcraft:crusher");
        GameRegistry.registerTileEntity(TileEntityIronFurnace.class, "mechanicalcraft:furnace");
        GameRegistry.registerTileEntity(TileEntityAlloyer.class, "mechanicalcraft:alloyer");
        GameRegistry.registerTileEntity(TileEntityMetalCompressor.class, "mechanicalcraft:metalConpressor");
        GameRegistry.registerTileEntity(TileEntityOreExtractor.class, "mechanicalcraft:oreExtractor");
    }
}
