package com.spyman.mechanicalcraft.common.blocks;

import com.spyman.mechanicalcraft.common.MechanicalCraft;

import com.spyman.mechanicalcraft.common.tileentity.TileEntityAlloyer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class Alloyer extends Block implements ITileEntityProvider
{
    public Alloyer(Material material)
    {
        super(material);
        setResistance(30);
        setHardness(3);
        setHarvestLevel("pickaxe", 2);
    }

    private static String machineType = "alloyer";
    public static String[] blockTexture = new String[]
    {
			/* 0 */MechanicalCraft.TEXTURE_NAME + "machine_side",
			/* 1 */MechanicalCraft.TEXTURE_NAME + machineType+"_front",
			/* 2 */MechanicalCraft.TEXTURE_NAME + machineType+"_front_on",
			/* 3 */MechanicalCraft.TEXTURE_NAME + "machine_bottom",
			/* 4 */MechanicalCraft.TEXTURE_NAME + "machine_top"
    };

    private IIcon top, bottom, side, frontOn, frontOff;
    TileEntityAlloyer tileEntityAlloyer;

	public void registerBlockIcons(IIconRegister iiconRegister)
	{
        this.frontOn = iiconRegister.registerIcon(blockTexture[2]);
        this.frontOff = iiconRegister.registerIcon(blockTexture[1]);
		this.top = iiconRegister.registerIcon(blockTexture[4]);
		this.bottom = iiconRegister.registerIcon(blockTexture[3]);
		this.side = iiconRegister.registerIcon(blockTexture[0]);
	}

	public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase living, ItemStack stack)
    {
		int direction = MathHelper.floor_double((double) (living.rotationYaw * 4.0F / 360.0F) + 2.5D) & 3;
        world.setBlockMetadataWithNotify(x, y, z, direction, 2);
	}

    @SideOnly(Side.CLIENT)
	public IIcon getIcon(int side, int metadata)
    {
		if (side == 0)
        {
            return this.bottom;
        }
		else if (side == 1)
        {
            return this.top;
        }

        if ((side == 3 && metadata == 0) || (side == 4 && metadata == 1) || (side == 2 && metadata == 2) || (side == 5 && metadata == 3))
        {
            return this.frontOff;
        }
        return this.side;
	}

    public TileEntity createNewTileEntity(World world, int metadata)
    {
        return new TileEntityAlloyer();
    }

    @Override
    public boolean hasTileEntity(int metadata)
    {
        return true;
    }
    
    public void breakBlock(World world, int x, int y, int z, Block block, int metadata)
    {
        TileEntity tileentity = world.getTileEntity(x, y, z);

        if (tileentity instanceof IInventory)
        {
            IInventory inv = (IInventory)tileentity;
            for (int i1 = 0; i1 < inv.getSizeInventory(); ++i1)
            {
                ItemStack itemstack = inv.getStackInSlot(i1);
        
                if (itemstack != null)
                {
                    float f = world.rand.nextFloat() * 0.8F + 0.1F;
                    float f1 = world.rand.nextFloat() * 0.8F + 0.1F;
                    EntityItem entityitem;
        
                    for (float f2 = world.rand.nextFloat() * 0.8F + 0.1F; itemstack.stackSize > 0; world.spawnEntityInWorld(entityitem))
                    {
                        int j1 = world.rand.nextInt(21) + 10;
        
                        if (j1 > itemstack.stackSize)
                        {
                            j1 = itemstack.stackSize;
                        }
        
                        itemstack.stackSize -= j1;
                        entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(itemstack.getItem(), j1, itemstack.getItemDamage()));
                        float f3 = 0.05F;
                        entityitem.motionX = (double)((float)world.rand.nextGaussian() * f3);
                        entityitem.motionY = (double)((float)world.rand.nextGaussian() * f3 + 0.2F);
                        entityitem.motionZ = (double)((float)world.rand.nextGaussian() * f3);
        
                        if (itemstack.hasTagCompound())
                        {
                            entityitem.getEntityItem().setTagCompound((NBTTagCompound)itemstack.getTagCompound().copy());
                        }
                    }
                }
            }
            world.func_147453_f(x, y, z, block);
        }
        super.breakBlock(world, x, y, z, block, metadata);
    }
    
    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitx, float hity, float hitz)
    {
        if (world.isRemote)
        {
            return true;
        }
        else
        {
        	player.openGui(MechanicalCraft.instance, 2, world, x, y, z);
        	return true;
        }
    }
}
