package com.spyman.mechanicalcraft.common;

import com.spyman.mechanicalcraft.common.blocks.*;
import com.spyman.mechanicalcraft.common.event.BlockEventHandler;
import com.spyman.mechanicalcraft.common.recipe.AlloyerRecipes;
import com.spyman.mechanicalcraft.common.recipe.CrusherRecipes;
import com.spyman.mechanicalcraft.common.recipe.MechanicalCraftRecipes;
import com.spyman.mechanicalcraft.common.recipe.MetalCompressorRecipes;
import com.spyman.mechanicalcraft.common.world.WorldGeneration;
import com.spyman.mechanicalcraft.proxy.CommonProxy;

import com.spyman.mechanicalcraft.common.items.*;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.EventHandler;
import cpw.mods.fml.common.Mod.Instance;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid = "mechanicalcraft", name = "MechanicalCraft_release", version = "0.2")
public class MechanicalCraft
{
	@Instance("mechanicalcraft")
	public static MechanicalCraft instance;

	@SidedProxy(clientSide = "com.spyman.mechanicalcraft.proxy.ClientProxy", serverSide = "com.spyman.mechanicalcraft.proxy.CommonProxy")
	public static CommonProxy proxy;
	
	public static final String MOD_ID = "mechanicalcraft";
	public static final String TEXTURE_NAME = MOD_ID + ":";

	public static CreativeTabs creatab = new MechanicalCraftCreativeTab("Ctab");

	@EventHandler
	public void preInit(FMLPreInitializationEvent event)
	{
		proxy.registerRender();

		WorldGeneration worldgeneration = new WorldGeneration();
		GameRegistry.registerWorldGenerator(worldgeneration, 0);

		MechanicalCraftItems items = new MechanicalCraftItems();
		items.loadItems();
		MechanicalCraftBlocks blocks = new MechanicalCraftBlocks();
		blocks.loadBlocks();
		MechanicalCraftRecipes recipes = new MechanicalCraftRecipes();
		recipes.loadRecipes();
	}

	@EventHandler
	public void init(FMLInitializationEvent event) 
	{
		NetworkRegistry.INSTANCE.registerGuiHandler(instance, new GuiHandler());
	}

	@EventHandler
	public void postInit(FMLPostInitializationEvent event)
	{
		MinecraftForge.EVENT_BUS.register(new BlockEventHandler());
	}
}
