package com.spyman.mechanicalcraft.common;

import com.spyman.mechanicalcraft.common.container.ContainerAlloyer;
import com.spyman.mechanicalcraft.common.gui.GuiAlloyer;
import com.spyman.mechanicalcraft.common.tileentity.TileEntityAlloyer;
import com.spyman.mechanicalcraft.common.container.ContainerCrusher;
import com.spyman.mechanicalcraft.common.container.ContainerIronFurnace;
import com.spyman.mechanicalcraft.common.tileentity.TileEntityIronFurnace;
import com.spyman.mechanicalcraft.common.container.ContainerMetalCompressor;
import com.spyman.mechanicalcraft.common.gui.GuiMetalCompressor;
import com.spyman.mechanicalcraft.common.tileentity.TileEntityMetalCompressor;
import com.spyman.mechanicalcraft.common.container.ContainerOreExtractor;
import com.spyman.mechanicalcraft.common.gui.GuiOreExtractor;
import com.spyman.mechanicalcraft.common.tileentity.TileEntityOreExtractor;
import com.spyman.mechanicalcraft.common.gui.GuiCrusher;
import com.spyman.mechanicalcraft.common.tileentity.TileEntityCrusher;
import com.spyman.mechanicalcraft.common.gui.GuiIronFurnace;
import cpw.mods.fml.common.network.IGuiHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class GuiHandler implements IGuiHandler
{
	@Override
	public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z)
	{
		TileEntity tile = world.getTileEntity(x, y, z);
		if(tile instanceof TileEntityAlloyer)
		{
			return new ContainerAlloyer((TileEntityAlloyer)tile, player.inventory);
		}
		else if (tile instanceof TileEntityCrusher)
		{
			return new ContainerCrusher((TileEntityCrusher) tile, player.inventory);
		}
		else if (tile instanceof TileEntityIronFurnace)
		{
			return new ContainerIronFurnace((TileEntityIronFurnace) tile, player.inventory);
		}
		else if (tile instanceof TileEntityMetalCompressor)
		{
			return new ContainerMetalCompressor((TileEntityMetalCompressor) tile, player.inventory);
		}
		else if (tile instanceof TileEntityOreExtractor)
		{
			return new ContainerOreExtractor((TileEntityOreExtractor) tile, player.inventory);
		}
		return null;
	}

	@Override
	public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z)
	{
		TileEntity tile = world.getTileEntity(x, y, z);
		if(tile instanceof TileEntityAlloyer)
		{
			return new GuiAlloyer((TileEntityAlloyer)tile, player.inventory);
		}
		else if (tile instanceof TileEntityCrusher)
		{
			return new GuiCrusher((TileEntityCrusher)tile, player.inventory);
		}
		else if (tile instanceof TileEntityIronFurnace)
		{
			return new GuiIronFurnace((TileEntityIronFurnace) tile, player.inventory);
		}
		else if (tile instanceof TileEntityMetalCompressor)
		{
			return new GuiMetalCompressor((TileEntityMetalCompressor) tile, player.inventory);
		}
		else if (tile instanceof TileEntityOreExtractor)
		{
			return new GuiOreExtractor((TileEntityOreExtractor) tile, player.inventory);
		}
		return null;
	}
}
