package net.spyman.utils.common.items;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.spyman.utils.SpyUtil;
import net.spyman.utils.common.inventory.InventoryItemPortableFurnace;

public class ItemPortableFurnace extends Item
{
    public ItemPortableFurnace()
    {
        this.setMaxStackSize(1);
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(ItemStack itemStack, World world, EntityPlayer player, EnumHand hand)
    {
        player.openGui(SpyUtil.INSTANCE, 1, world, (int) player.posX, (int) player.posY, (int) player.posZ);
        return new ActionResult(EnumActionResult.PASS, itemStack);
    }

    @Override
    public void onUpdate(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected)
    {

    }
}
