package net.spyman.utils.common.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.spyman.utils.common.container.slot.SlotPortableFurnace;
import net.spyman.utils.common.inventory.InventoryItemPortableFurnace;
import net.spyman.utils.common.items.ItemPortableFurnace;

public class ContainerPortableFurnace extends Container
{
    InventoryItemPortableFurnace inventory;
    private int workingTime;
    private int workingTimeNeeded;

    public ContainerPortableFurnace(InventoryPlayer playerInv, InventoryItemPortableFurnace inv)
    {
        this.inventory = inv;
        int j;
        int k;

        this.addSlotToContainer(new Slot(this.inventory, 0, 56, 17));                   // input
        this.addSlotToContainer(new Slot(this.inventory, 1, 56, 53));                   // coal
        this.addSlotToContainer(new SlotPortableFurnace(this.inventory, 2, 116, 35));   // output

        this.bindPlayerInventory(playerInv);
    }

    @Override
    public boolean canInteractWith(EntityPlayer playerIn)
    {
        return true;
    }

    private void bindPlayerInventory(InventoryPlayer inventory)
    {
        int i;
        for (i = 0; i < 3; ++i)
        {
            for (int j = 0; j < 9; ++j)
            {
                this.addSlotToContainer(new Slot(inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }

        for (i = 0; i < 9; ++i)
        {
            this.addSlotToContainer(new Slot(inventory, i, 8 + i * 18, 142));
        }
    }

    @Override
    public ItemStack transferStackInSlot(EntityPlayer player, int quantity)
    {
        ItemStack itemstack = null;
        Slot slot = (Slot)this.inventorySlots.get(quantity);

        if (slot != null && slot.getHasStack())
        {
            ItemStack itemStack1 = slot.getStack();
            itemstack = itemStack1.copy();

            if (quantity < this.inventory.getSizeInventory())
            {
                if (!this.mergeItemStack(itemStack1, this.inventory.getSizeInventory(), this.inventorySlots.size(), true))
                {
                    return null;
                }
            }
            else if (!this.mergeItemStack(itemStack1, 0, this.inventory.getSizeInventory(), false))
            {
                return null;
            }

            if (itemStack1.stackSize == 0)
            {
                slot.putStack((ItemStack)null);
            }
            else
            {
                slot.onSlotChanged();
            }
        }
        return itemstack;
    }

    @Override
    public void onContainerClosed(EntityPlayer player)
    {
        super.onContainerClosed(player);
        this.inventory.closeInventory(player);
    }

    @SideOnly(Side.CLIENT)
    public void updateProgressBar(int id, int value)
    {
        if(id == 0)
        {
            this.inventory.workingTime = value;
        }

        if(id == 1)
        {
            this.inventory.workingTimeNeeded = value;
        }
    }
}
