package net.spyman.utils.common.world;

import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.spyman.utils.SpyUtil;
import net.spyman.utils.common.blocks.SpyUtilBlocks;

import java.util.Random;

public class WorldGeneration implements IWorldGenerator
{
    @Override
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider)
    {
        switch(world.provider.getDimension())
        {

            case -1:
                generateNether(world, random, chunkX * 16, chunkZ * 16);
                break;

            case 0:
                generateSurface(world, random, chunkX * 16, chunkZ * 16);
                break;

            case 1:
                generateEnd(world, random, chunkX * 16, chunkZ * 16);
                break;
        }
    }

    // this.addOreSpawn(block, metadata, replace block, world, random, x, z, 16, 16, maxOreSize, rarity, Y min, Y max);

    private void generateEnd(World world, Random random, int x, int z)
    {

    }

    private void generateSurface(World world, Random random, int x, int z)
    {
        this.addOreSpawn(SpyUtilBlocks.BLOCK_ORE_COPPER     , 0, world, random, x, z, 16, 16, 10, 16, 5, 128);
        this.addOreSpawn(SpyUtilBlocks.BLOCK_ORE_TIN        , 0, world, random, x, z, 16, 16, 10, 16, 5, 128);
        this.addOreSpawn(SpyUtilBlocks.BLOCK_ORE_LEAD       , 0, world, random, x, z, 16, 16, 8 , 10, 5, 48);
        this.addOreSpawn(SpyUtilBlocks.BLOCK_ORE_SILVER     , 0, world, random, x, z, 16, 16, 8 , 10, 5, 24);
        this.addOreSpawn(SpyUtilBlocks.BLOCK_ORE_ALUMINIUM  , 0, world, random, x, z, 16, 16, 8 , 12, 5, 64);
    }

    private void generateNether(World world, Random random, int x, int z)
    {

    }

    public void addOreSpawn(Block block, int metadata, World world, Random random, int blockXPos, int blockZPos, int maxX, int maxZ, int maxVeinSize, int chancesToSpawn, int minY, int maxY)
    {
        assert maxY > minY :            "Ymax >>> Ymin";
        assert maxX > 0 && maxX <= 16 : "0 < X < 16";
        assert minY > 0 :               "Y >>> 0";
        assert maxY < 256 && maxY > 0 : "0 < Y < 256";
        assert maxZ > 0 && maxZ <= 16 : "0 < Z < 16";

        for(int i = 0; i < chancesToSpawn; i++)
        {
            int posY = random.nextInt(128);

            if((posY <= maxY) && (posY >= minY))
            {
                (new WorldGenMinable(block.getDefaultState(), maxVeinSize)).generate(world, random, new BlockPos(blockXPos, posY, blockZPos));
            }
        }
    }
}
