package net.spyman.utils.common.recipes;

import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.spyman.utils.common.blocks.SpyUtilBlocks;
import net.spyman.utils.common.items.SpyUtilItems;

public class SpyUtilRecipes
{
    protected static final ItemStack[] ITEMS_SMELT = new ItemStack[]
    {
        // Part 1
        new ItemStack(SpyUtilItems.DUST_GOLD, 1, 0),
        new ItemStack(SpyUtilItems.DUST_IRON, 1, 0),
        new ItemStack(SpyUtilItems.DUST_COPPER, 1, 0),
        new ItemStack(SpyUtilItems.DUST_TIN, 1, 0),
        new ItemStack(SpyUtilItems.DUST_LEAD, 1, 0),
        new ItemStack(SpyUtilItems.DUST_ALUMINIUM, 1, 0),
        new ItemStack(SpyUtilItems.DUST_SILVER, 1, 0),
        new ItemStack(SpyUtilItems.DUST_STEEL, 1, 0),
        new ItemStack(SpyUtilItems.DUST_ELECTRUM, 1, 0),
        new ItemStack(SpyUtilItems.DUST_BRONZE, 1, 0),
        // Part 2
        new ItemStack(SpyUtilBlocks.BLOCK_ORE_ALUMINIUM, 1, 0),
        new ItemStack(SpyUtilBlocks.BLOCK_ORE_COPPER, 1, 0),
        new ItemStack(SpyUtilBlocks.BLOCK_ORE_LEAD, 1, 0),
        new ItemStack(SpyUtilBlocks.BLOCK_ORE_SILVER, 1, 0),
        new ItemStack(SpyUtilBlocks.BLOCK_ORE_TIN, 1, 0)
    };

    protected static final ItemStack[] ITEMS_RESULT = new ItemStack[]
    {
        // Part 1
        new ItemStack(Items.GOLD_INGOT, 1, 0),
        new ItemStack(Items.IRON_INGOT, 1, 0),
        new ItemStack(SpyUtilItems.INGOT_COPPER, 1, 0),
        new ItemStack(SpyUtilItems.INGOT_TIN, 1, 0),
        new ItemStack(SpyUtilItems.INGOT_LEAD, 1, 0),
        new ItemStack(SpyUtilItems.INGOT_ALUMINIUM, 1, 0),
        new ItemStack(SpyUtilItems.INGOT_SILVER, 1, 0),
        new ItemStack(SpyUtilItems.INGOT_STEEL, 1, 0),
        new ItemStack(SpyUtilItems.INGOT_ELECTRUM, 1, 0),
        new ItemStack(SpyUtilItems.INGOT_BRONZE, 1, 0),
        // Part 2
        new ItemStack(SpyUtilItems.INGOT_ALUMINIUM, 1, 0),
        new ItemStack(SpyUtilItems.INGOT_COPPER, 1, 0),
        new ItemStack(SpyUtilItems.INGOT_LEAD, 1, 0),
        new ItemStack(SpyUtilItems.INGOT_SILVER, 1, 0),
        new ItemStack(SpyUtilItems.INGOT_TIN, 1, 0)
    };

    private static int ItemsSmeltTabSize = ITEMS_SMELT.length;
    private static int ItemsResultTabSize = ITEMS_RESULT.length;

    public static void addRecipes()
    {
        /*
         * This recipes are added to allow to make lava_bucket and clay_ball
         */
        GameRegistry.addRecipe(new ItemStack(Items.CLAY_BALL, 16, 0), new Object[]
        {
            "WS",
            "D#",
            'W', new ItemStack(Items.WATER_BUCKET),
            'D', new ItemStack(Blocks.DIRT),
            'S', new ItemStack(Blocks.SAND, 1, OreDictionary.WILDCARD_VALUE)
        });
        GameRegistry.addRecipe(new ItemStack(Items.CLAY_BALL, 16, 0), new Object[]
        {
            "WS",
            "D#",
            'W', new ItemStack(Items.POTIONITEM),
            'D', new ItemStack(Blocks.DIRT),
            'S', new ItemStack(Blocks.SAND, 1, OreDictionary.WILDCARD_VALUE)
        });
        GameRegistry.addRecipe(new ItemStack(Items.LAVA_BUCKET), new Object[]
        {
            "#N#",
            "NLN",
            "#N#",
            'L', new ItemStack(Items.BUCKET),
            'N', new ItemStack(Blocks.field_189877_df)
        });
        /*
         * This recipes is used to make alloys metals (electrum, steel, bronze).
         */
        GameRegistry.addRecipe(new ShapelessOreRecipe(new ItemStack(SpyUtilItems.DUST_BRONZE, 2, 0), new Object[]
        {
            "dustCopper",
            "dustTin"
        }));
        GameRegistry.addRecipe(new ShapelessOreRecipe(new ItemStack(SpyUtilItems.DUST_STEEL, 2, 0), new Object[]
        {
            "dustCoal",
            "dustIron"
        }));
        GameRegistry.addRecipe(new ShapelessOreRecipe(new ItemStack(SpyUtilItems.DUST_ELECTRUM, 2, 0), new Object[]
        {
            "dustSilver",
            "dustGold"
        }));

        for (int i = 0; i < ItemsSmeltTabSize ; i++)
        {
            GameRegistry.addSmelting(ITEMS_SMELT[i], ITEMS_RESULT[i], 2.0F);
        }

        GameRegistry.addRecipe(new ItemStack(SpyUtilBlocks.BLOCK_LANTERN), new Object[]
        {
            "SSS",
            "GTG",
            "SSS",
            'T', new ItemStack(Blocks.TORCH),
            'S', new ItemStack(Blocks.STONE),
            'G', new ItemStack(Blocks.GLASS_PANE)
        });
        GameRegistry.addRecipe(new ItemStack(SpyUtilItems.BAG), new Object[]
        {
            "SLS",
            "LLL",
            'S', new ItemStack(Items.STRING),
            'L', new ItemStack(Items.LEATHER)
        });
        GameRegistry.addRecipe(new ItemStack(SpyUtilItems.HEALTH_WAND), new Object[]
        {
            "0HG",
            "0DH",
            "S00",
            'S', new ItemStack(Items.STICK),
            'G', new ItemStack(Items.GOLD_INGOT),
            'H', new ItemStack(Items.POTIONITEM, 1, 8229),
            'D', new ItemStack(Items.DIAMOND)
        });
    }
}
