package net.spyman.utils.common.items;

import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.spyman.utils.SpyUtil;

public class SpyUtilItems
{
    /* Dusts */
    public static final Item DUST_IRON = new ItemsDusts().setUnlocalizedName("dust_iron").setCreativeTab(SpyUtil.SPYUTIL_TAB);
    public static final Item DUST_GOLD = new ItemsDusts().setUnlocalizedName("dust_gold").setCreativeTab(SpyUtil.SPYUTIL_TAB);
    public static final Item DUST_COAL = new ItemsDusts().setUnlocalizedName("dust_coal").setCreativeTab(SpyUtil.SPYUTIL_TAB);
    public static final Item DUST_STEEL = new ItemsDusts().setUnlocalizedName("dust_steel").setCreativeTab(SpyUtil.SPYUTIL_TAB);
    public static final Item DUST_ALUMINIUM = new ItemsDusts().setUnlocalizedName("dust_aluminium").setCreativeTab(SpyUtil.SPYUTIL_TAB);
    public static final Item DUST_ELECTRUM = new ItemsDusts().setUnlocalizedName("dust_electrum").setCreativeTab(SpyUtil.SPYUTIL_TAB);
    public static final Item DUST_COPPER = new ItemsDusts().setUnlocalizedName("dust_copper").setCreativeTab(SpyUtil.SPYUTIL_TAB);
    public static final Item DUST_TIN = new ItemsDusts().setUnlocalizedName("dust_tin").setCreativeTab(SpyUtil.SPYUTIL_TAB);
    public static final Item DUST_SILVER = new ItemsDusts().setUnlocalizedName("dust_silver").setCreativeTab(SpyUtil.SPYUTIL_TAB);
    public static final Item DUST_LEAD = new ItemsDusts().setUnlocalizedName("dust_lead").setCreativeTab(SpyUtil.SPYUTIL_TAB);
    public static final Item DUST_BRONZE = new ItemsDusts().setUnlocalizedName("dust_bronze").setCreativeTab(SpyUtil.SPYUTIL_TAB);
    /* Ingots */
    public static final Item INGOT_COPPER = new ItemsIngots().setUnlocalizedName("ingot_copper").setCreativeTab(SpyUtil.SPYUTIL_TAB);
    public static final Item INGOT_TIN = new ItemsIngots().setUnlocalizedName("ingot_tin").setCreativeTab(SpyUtil.SPYUTIL_TAB);
    public static final Item INGOT_ELECTRUM = new ItemsIngots().setUnlocalizedName("ingot_electrum").setCreativeTab(SpyUtil.SPYUTIL_TAB);
    public static final Item INGOT_STEEL = new ItemsIngots().setUnlocalizedName("ingot_steel").setCreativeTab(SpyUtil.SPYUTIL_TAB);
    public static final Item INGOT_ALUMINIUM = new ItemsIngots().setUnlocalizedName("ingot_aluminium").setCreativeTab(SpyUtil.SPYUTIL_TAB);
    public static final Item INGOT_SILVER = new ItemsIngots().setUnlocalizedName("ingot_silver").setCreativeTab(SpyUtil.SPYUTIL_TAB);
    public static final Item INGOT_LEAD = new ItemsIngots().setUnlocalizedName("ingot_lead").setCreativeTab(SpyUtil.SPYUTIL_TAB);
    public static final Item INGOT_BRONZE = new ItemsIngots().setUnlocalizedName("ingot_bronze").setCreativeTab(SpyUtil.SPYUTIL_TAB);
    /* Others Items */
    public static final Item BAG = new ItemBag().setUnlocalizedName("bag").setCreativeTab(SpyUtil.SPYUTIL_TAB);
    public static final Item HEALTH_WAND = new ItemHealthWand().setUnlocalizedName("health_wand").setCreativeTab(SpyUtil.SPYUTIL_TAB);
    public static final Item PORTABLE_FURNACE = new ItemPortableFurnace().setUnlocalizedName("portable_furnace").setCreativeTab(SpyUtil.SPYUTIL_TAB);

    public static void registerItems()
    {
        /* Dusts */
        GameRegistry.registerItem(DUST_IRON, "dust_iron");
        GameRegistry.registerItem(DUST_GOLD, "dust_gold");
        GameRegistry.registerItem(DUST_COAL, "dust_coal");
        GameRegistry.registerItem(DUST_TIN, "dust_tin");
        GameRegistry.registerItem(DUST_COPPER, "dust_copper");
        GameRegistry.registerItem(DUST_ALUMINIUM, "dust_aluminium");
        GameRegistry.registerItem(DUST_STEEL, "dust_steel");
        GameRegistry.registerItem(DUST_ELECTRUM, "dust_electrum");
        GameRegistry.registerItem(DUST_SILVER, "dust_silver");
        GameRegistry.registerItem(DUST_LEAD, "dust_lead");
        GameRegistry.registerItem(DUST_BRONZE, "dust_bronze");
        /* Ingots */
        GameRegistry.registerItem(INGOT_COPPER, "ingot_copper");
        GameRegistry.registerItem(INGOT_TIN, "ingot_tin");
        GameRegistry.registerItem(INGOT_ALUMINIUM, "ingot_aluminium");
        GameRegistry.registerItem(INGOT_STEEL, "ingot_steel");
        GameRegistry.registerItem(INGOT_ELECTRUM, "ingot_electrum");
        GameRegistry.registerItem(INGOT_SILVER, "ingot_silver");
        GameRegistry.registerItem(INGOT_LEAD, "ingot_lead");
        GameRegistry.registerItem(INGOT_BRONZE, "ingot_bronze");
        /* Other Items */
        GameRegistry.registerItem(BAG, "bag");
        GameRegistry.registerItem(HEALTH_WAND, "health_wand");
        GameRegistry.registerItem(PORTABLE_FURNACE, "portable_furnace");

        /* Ore Dictionary */

        /* OreDic : Dusts */
        OreDictionary.registerOre("dustIron", DUST_IRON);
        OreDictionary.registerOre("dustGold", DUST_GOLD);
        OreDictionary.registerOre("dustCoal", DUST_COAL);
        OreDictionary.registerOre("dustCopper", DUST_COPPER);
        OreDictionary.registerOre("dustTin", DUST_TIN);
        OreDictionary.registerOre("dustAluminium", DUST_ALUMINIUM);
        OreDictionary.registerOre("dustLead", DUST_LEAD);
        OreDictionary.registerOre("dustSilver", DUST_SILVER);
        OreDictionary.registerOre("dustSteel", DUST_STEEL);
        OreDictionary.registerOre("dustBronze", DUST_BRONZE);
        OreDictionary.registerOre("dustElectrum", DUST_ELECTRUM);
        /* OreDic : Ingots */
        OreDictionary.registerOre("ingotCopper", INGOT_COPPER);
        OreDictionary.registerOre("ingotTin", INGOT_TIN);
        OreDictionary.registerOre("ingotAluminium", INGOT_ALUMINIUM);
        OreDictionary.registerOre("ingotLead", INGOT_LEAD);
        OreDictionary.registerOre("ingotSilver", INGOT_SILVER);
        OreDictionary.registerOre("ingotSteel", INGOT_STEEL);
        OreDictionary.registerOre("ingotBronze", INGOT_BRONZE);
        OreDictionary.registerOre("ingotElectrum", INGOT_ELECTRUM);
    }

    @SideOnly(Side.CLIENT)
    public static void registerItemsModels()
    {
        /* Dusts */
        ModelLoader.setCustomModelResourceLocation(DUST_COAL, 0, new ModelResourceLocation(SpyUtil.PATH + "dust_coal", "inventory"));
        ModelLoader.setCustomModelResourceLocation(DUST_IRON, 0, new ModelResourceLocation(SpyUtil.PATH + "dust_iron", "inventory"));
        ModelLoader.setCustomModelResourceLocation(DUST_GOLD, 0, new ModelResourceLocation(SpyUtil.PATH + "dust_gold", "inventory"));
        ModelLoader.setCustomModelResourceLocation(DUST_TIN, 0, new ModelResourceLocation(SpyUtil.PATH + "dust_tin", "inventory"));
        ModelLoader.setCustomModelResourceLocation(DUST_COPPER, 0, new ModelResourceLocation(SpyUtil.PATH + "dust_copper", "inventory"));
        ModelLoader.setCustomModelResourceLocation(DUST_ALUMINIUM, 0, new ModelResourceLocation(SpyUtil.PATH + "dust_aluminium", "inventory"));
        ModelLoader.setCustomModelResourceLocation(DUST_STEEL, 0, new ModelResourceLocation(SpyUtil.PATH + "dust_steel", "inventory"));
        ModelLoader.setCustomModelResourceLocation(DUST_ELECTRUM, 0, new ModelResourceLocation(SpyUtil.PATH + "dust_electrum", "inventory"));
        ModelLoader.setCustomModelResourceLocation(DUST_SILVER, 0, new ModelResourceLocation(SpyUtil.PATH + "dust_silver", "inventory"));
        ModelLoader.setCustomModelResourceLocation(DUST_LEAD, 0, new ModelResourceLocation(SpyUtil.PATH + "dust_lead", "inventory"));
        ModelLoader.setCustomModelResourceLocation(DUST_BRONZE, 0, new ModelResourceLocation(SpyUtil.PATH + "dust_bronze", "inventory"));
        /* Ingots */
        ModelLoader.setCustomModelResourceLocation(INGOT_COPPER, 0, new ModelResourceLocation(SpyUtil.PATH + "ingot_copper", "inventory"));
        ModelLoader.setCustomModelResourceLocation(INGOT_TIN, 0, new ModelResourceLocation(SpyUtil.PATH + "ingot_tin", "inventory"));
        ModelLoader.setCustomModelResourceLocation(INGOT_ALUMINIUM, 0, new ModelResourceLocation(SpyUtil.PATH + "ingot_aluminium", "inventory"));
        ModelLoader.setCustomModelResourceLocation(INGOT_STEEL, 0, new ModelResourceLocation(SpyUtil.PATH + "ingot_steel", "inventory"));
        ModelLoader.setCustomModelResourceLocation(INGOT_ELECTRUM, 0, new ModelResourceLocation(SpyUtil.PATH + "ingot_electrum", "inventory"));
        ModelLoader.setCustomModelResourceLocation(INGOT_LEAD, 0, new ModelResourceLocation(SpyUtil.PATH + "ingot_lead", "inventory"));
        ModelLoader.setCustomModelResourceLocation(INGOT_SILVER, 0, new ModelResourceLocation(SpyUtil.PATH + "ingot_silver", "inventory"));
        ModelLoader.setCustomModelResourceLocation(INGOT_BRONZE, 0, new ModelResourceLocation(SpyUtil.PATH + "ingot_bronze", "inventory"));
        /* Others Items */
        ModelLoader.setCustomModelResourceLocation(BAG, 0, new ModelResourceLocation(SpyUtil.PATH + "item_bag", "inventory"));
        ModelLoader.setCustomModelResourceLocation(HEALTH_WAND, 0, new ModelResourceLocation(SpyUtil.PATH + "health_wand", "inventory"));
        ModelLoader.setCustomModelResourceLocation(PORTABLE_FURNACE, 0, new ModelResourceLocation(SpyUtil.PATH + "portable_furnace", "inventory"));
    }
}
