package net.spyman.utils.common.items;

import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class ItemHealthWand extends Item
{
    /** Count of hearts per heal. */
    private float heartsCount = 4.0F;
    /** Durability of this item. */
    private int maxDamage = 20;

    public ItemHealthWand()
    {
        this.setMaxDamage(this.maxDamage);
        this.setMaxStackSize(1);
        this.isDamageable();
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(ItemStack itemStack, World world, EntityPlayer player, EnumHand hand)
    {
        if (!world.isRemote)
        {
            if (player.getHealth() < player.getMaxHealth())
            {
                player.heal(this.heartsCount);
                itemStack.damageItem(1, player);
            }
        }
        return new ActionResult(EnumActionResult.PASS, itemStack);
    }
}
