package net.spyman.utils.common.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.util.Constants;
import net.spyman.utils.common.items.ItemBag;
import net.spyman.utils.common.items.SpyUtilItems;

import javax.annotation.Nullable;

public class InventoryItemBag implements IInventory
{
    public ItemStack[] inventorySlots;
    public int inventoryStackLimit = 64;
    /**
     * This variable define quantity of slots.
     * Use only a multiple of 9 (27, 54, 81, ...)
     */
    public int inventorySize = 54;

    public InventoryItemBag(ItemStack container, int size)
    {
        this.inventorySize = size;
        this.inventorySlots = new ItemStack[size];

        if (!container.hasTagCompound())
        {
            container.setTagCompound(new NBTTagCompound());
        }

            this.readFromNBT(container.getTagCompound());
    }

    public void readFromNBT(NBTTagCompound comp)
    {
        NBTTagList nbtlist = comp.getTagList("Inventory", Constants.NBT.TAG_COMPOUND);

        for (int i = 0; i < nbtlist.tagCount(); i++)
        {
            comp = nbtlist.getCompoundTagAt(i);
            int slot = comp.getInteger("Slot");
            this.inventorySlots[slot] = ItemStack.loadItemStackFromNBT(comp);
        }
    }

    public void writeToNBT(NBTTagCompound comp)
    {
        NBTTagList nbtlist = new NBTTagList();

        for (int i = 0; i < this.inventorySize; i++)
        {
            if (this.inventorySlots[i] != null)
            {
                NBTTagCompound comp1 = new NBTTagCompound();
                comp1.setInteger("Slot", i);
                this.inventorySlots[i].writeToNBT(comp1);
                nbtlist.appendTag(comp1);
            }
        }
        comp.setTag("Inventory", nbtlist);
    }

    @Override
    public int getSizeInventory()
    {
        return this.inventorySize;
    }

    @Nullable
    @Override
    public ItemStack getStackInSlot(int index)
    {
        return this.inventorySlots[index];
    }

    @Nullable
    @Override
    public ItemStack decrStackSize(int index, int count)
    {
        ItemStack stack = getStackInSlot(index);

        if (stack != null)
        {
            if (stack.stackSize > count)
            {
                stack = stack.splitStack(count);
                if (stack.stackSize == 0)
                {
                    this.inventorySlots[index] = null;
                }
            }
            else
            {
                this.inventorySlots[index] = null;
            }
        }
        return stack;
    }

    @Nullable
    @Override
    public ItemStack removeStackFromSlot(int index)
    {
        return null;
    }

    @Override
    public void setInventorySlotContents(int index, @Nullable ItemStack stack)
    {
        this.inventorySlots[index] = stack;
    }

    @Override
    public int getInventoryStackLimit()
    {
        return this.inventoryStackLimit;
    }

    @Override
    public void markDirty()
    {

    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer player)
    {
        return true;
    }

    @Override
    public void openInventory(EntityPlayer player)
    {

    }

    @Override
    public void closeInventory(EntityPlayer player)
    {

    }

    @Override
    public boolean isItemValidForSlot(int index, ItemStack stack)
    {
        return !(stack.getItem() instanceof ItemBag);
    }

    @Override
    public int getField(int id)
    {
        return 0;
    }

    @Override
    public void setField(int id, int value)
    {

    }

    @Override
    public int getFieldCount()
    {
        return 0;
    }

    @Override
    public void clear()
    {

    }

    @Override
    public String getName()
    {
        return "item.container.bag.gui";
    }

    @Override
    public boolean hasCustomName()
    {
        return false;
    }

    @Override
    public ITextComponent getDisplayName()
    {
        return null;
    }
}
