package net.spyman.utils.common.gui;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.spyman.utils.common.container.ContainerPortableFurnace;
import net.spyman.utils.common.inventory.InventoryItemPortableFurnace;
import net.spyman.utils.common.items.ItemPortableFurnace;
import org.lwjgl.opengl.GL11;

public class GuiPortableFurnace extends GuiContainer
{
    public static final ResourceLocation texture = new ResourceLocation("textures/gui/container/furnace.png");
    private InventoryItemPortableFurnace inv;
    private InventoryPlayer playerInv;

    public GuiPortableFurnace(InventoryPlayer playerInventory, InventoryItemPortableFurnace inventoryPortableFurnace)
    {
        super(new ContainerPortableFurnace(playerInventory, inventoryPortableFurnace));
        this.playerInv = playerInventory;
        this.inv = inventoryPortableFurnace;
        this.allowUserInput = false;
        this.ySize = 166;
        this.xSize = 176;
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float p_146976_1_, int p_146976_2_, int p_146976_3_)
    {
        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
        this.mc.getTextureManager().bindTexture(texture);
        int k = (this.width - this.xSize) / 2;
        int l = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(k, l, 0, 0, this.xSize, this.ySize);

        if(this.inv.isBurning())
        {
            /*  this.drawTexturedModalRect(x, y, u, v, width, height)
             *  -----------------------------------------------------
             *  x: X position --> on GUI
             *  y: Y position --> on GUI
             *  u: X position --> on texture
             *  v: Y position --> on texture
             *  width: WIDTH of a texture part
             *  height: HEIGHT of a texture part
             */
            int i = this.inv.getSmeltProcess();
            this.drawTexturedModalRect(k + 79, l + 35, 176, 14, i + 1, 16);
        }
        if (inv.burnTimeTotal > 0 && inv.getBurnTime() > 0)
        {
            int p = this.inv.getBurnTime();
            this.drawTexturedModalRect(k + 57, l + 36 + (14 - p), 176, 14 - p, 14, p);
        }
    }

    protected void drawGuiContainerForegroundLayer(int x, int y)
    {
        String s = this.inv.hasCustomName() ? this.inv.getName() : I18n.format(this.inv.getName(), new Object[0]);
        this.fontRendererObj.drawString(s, this.xSize / 2 - this.fontRendererObj.getStringWidth(s) / 2, 6, 4210752);
        this.fontRendererObj.drawString(this.playerInv.hasCustomName() ? this.playerInv.getName() : I18n.format(this.playerInv.getName()), 9, 73, 4210752);
        this.fontRendererObj.drawString((100 * inv.workingTime / inv.workingTimeNeeded) + "%", 80, 57, 4210752);

    }
}
