package net.spyman.utils.common.gui;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.spyman.utils.common.container.ContainerItemBag;
import net.spyman.utils.common.container.ContainerPortableFurnace;
import net.spyman.utils.common.inventory.InventoryItemBag;
import net.spyman.utils.common.inventory.InventoryItemPortableFurnace;
import net.spyman.utils.common.items.ItemBag;
import net.spyman.utils.common.items.ItemPortableFurnace;

public class GuiHandler implements IGuiHandler
{
    @Override
    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z)
    {
        switch (ID)
        {
            case 0:
            {
                if (player.getHeldItem(EnumHand.MAIN_HAND) == null || !(player.getHeldItem(EnumHand.MAIN_HAND).getItem() instanceof ItemBag))
                {
                    return null;
                }
                return new ContainerItemBag(player.inventory, new InventoryItemBag(player.getHeldItem(EnumHand.MAIN_HAND), 54));
            }
            case 1:
            {
                if (player.getHeldItem(EnumHand.MAIN_HAND) == null || !(player.getHeldItem(EnumHand.MAIN_HAND).getItem() instanceof ItemPortableFurnace))
                {
                    return null;
                }
                return new ContainerPortableFurnace(player.inventory, new InventoryItemPortableFurnace(player.getHeldItem(EnumHand.MAIN_HAND)));
            }
        }
        return null;
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z)
    {
        switch (ID)
        {
            case 0:
            {
                if (player.getHeldItem(EnumHand.MAIN_HAND) == null || !(player.getHeldItem(EnumHand.MAIN_HAND).getItem() instanceof ItemBag))
                {
                    return null;
                }
                else
                {
                    return new GuiItemBag(player.inventory, new InventoryItemBag(player.getHeldItem(EnumHand.MAIN_HAND), 54));
                }
            }
            case 1:
            {
                if (player.getHeldItem(EnumHand.MAIN_HAND) == null || !(player.getHeldItem(EnumHand.MAIN_HAND).getItem() instanceof ItemPortableFurnace))
                {
                    return null;
                }
                else
                {
                    return new GuiPortableFurnace(player.inventory, new InventoryItemPortableFurnace(player.getHeldItem(EnumHand.MAIN_HAND)));
                }
            }
        }
        return null;
    }
}
