package net.spyman.utils.common.events;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EventHandler
{
    // This events are used to get back to 1.8 PvP

    /** New value for ATTACK_SPEED modifier */
    protected final double ATTACK_SPEED = 100.0D;

    /* This event is called when a player join a world */
    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event)
    {
        /*
         * "ATTACK_SPEED" is a modifier of ItemTool(sword, pickaxe, ...)
         * this is the cooldown before next hit
         */
        event.player.getEntityAttribute(SharedMonsterAttributes.ATTACK_SPEED).setBaseValue(this.ATTACK_SPEED);
    }

    /* This event is called when a player respawn after death */
    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event)
    {
        /*
         * "ATTACK_SPEED" is a modifier of ItemTool(sword, pickaxe, ...)
         * this is the cooldown before next hit
         */
        event.player.getEntityAttribute(SharedMonsterAttributes.ATTACK_SPEED).setBaseValue(this.ATTACK_SPEED);
    }

    /*
     * This event is called when player drop a item.
     * *********************************************
     * This is the Notch's Apple ritual !
     *  /!\ Use with extreme precaution !
     * Thunder can will hit you during the ritual !
     */
    @SubscribeEvent
    public void onItemDrop(ItemTossEvent event)
    {
        World world = event.getEntityItem().getEntityWorld();
        EntityPlayer player = event.getPlayer();
        ItemStack itemGoldApple1 = new ItemStack(Items.GOLDEN_APPLE, 1, 1);
        ItemStack itemStack = event.getEntityItem().getEntityItem();
        int x = event.getEntityItem().getPosition().getX();
        int y = event.getEntityItem().getPosition().getY();
        int z = event.getEntityItem().getPosition().getZ();
        BlockPos[] blockPos = new BlockPos[]
        {
            new BlockPos(x - 1, y - 2, z + 1),
            new BlockPos(x + 1, y - 2, z - 1),
            new BlockPos(x + 1, y - 2, z + 1),
            new BlockPos(x, y - 2, z - 1),
            new BlockPos(x, y - 2, z),
            new BlockPos(x + 1, y - 2, z),
            new BlockPos(x - 1, y - 2, z),
            new BlockPos(x, y - 2, z + 1),
            new BlockPos(x - 1, y - 2, z - 1)
        };

        if (itemStack.getItem() == Items.GOLDEN_APPLE && itemStack.getMetadata() == 0)
        {
            if (world.getBlockState(blockPos[0]).getBlock() == Blocks.GOLD_BLOCK)
            {
                if (world.getBlockState(blockPos[1]).getBlock() == Blocks.GOLD_BLOCK)
                {
                    if (world.getBlockState(blockPos[2]).getBlock() == Blocks.GOLD_BLOCK)
                    {
                        if (world.getBlockState(blockPos[3]).getBlock() == Blocks.GOLD_BLOCK)
                        {
                            if (world.getBlockState(blockPos[4]).getBlock() == Blocks.GOLD_BLOCK)
                            {
                                if (world.getBlockState(blockPos[5]).getBlock() == Blocks.GOLD_BLOCK)
                                {
                                    if (world.getBlockState(blockPos[6]).getBlock() == Blocks.GOLD_BLOCK)
                                    {
                                        if (world.getBlockState(blockPos[7]).getBlock() == Blocks.GOLD_BLOCK)
                                        {
                                            if (world.getBlockState(blockPos[8]).getBlock() == Blocks.GOLD_BLOCK)
                                            {
                                                if (player.getHealth() == 20.0F)
                                                {
                                                    player.setHealth(1.0F);
                                                    world.spawnEntityInWorld(new EntityLightningBolt(world, x, y, z, true));
                                                    world.addWeatherEffect(new EntityLightningBolt(world, x, y, z, true));
                                                    world.spawnEntityInWorld(new EntityItem(world, x, y, z, itemGoldApple1));
                                                    for (int i = 0 ; i < blockPos.length ; i++)
                                                    {
                                                        world.setBlockState(blockPos[i], Blocks.STONE.getDefaultState());
                                                    }
                                                    event.getEntityItem().setDead();
                                                }
                                                else
                                                {
                                                    if (!world.isRemote)
                                                    {
                                                        player.addChatComponentMessage(new TextComponentTranslation("ritual.life_lower.message"));
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}
