package net.spyman.utils.common.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.spyman.utils.common.container.slot.SlotItemBag;
import net.spyman.utils.common.inventory.InventoryItemBag;
import net.spyman.utils.common.items.ItemBag;
import net.spyman.utils.common.items.SpyUtilItems;

public class ContainerItemBag extends Container
{
    public InventoryItemBag invBackpack;
    public int rows;

    public ContainerItemBag(InventoryPlayer playerInv, InventoryItemBag inv)
    {
        this.invBackpack = inv;
        this.rows = inv.getSizeInventory() / 9;
        int i = (this.rows - 4) * 18;
        int j;
        int k;

        for (j = 0; j < this.rows; ++j)
        {
            for (k = 0; k < 9; ++k)
            {
                this.addSlotToContainer(new SlotItemBag(inv, k + j * 9, 8 + k * 18, 18 + j * 18));
            }
        }

        for (j = 0; j < 3; ++j)
        {
            for (k = 0; k < 9; ++k)
            {
                this.addSlotToContainer(new Slot(playerInv, k + j * 9 + 9, 8 + k * 18, 103 + j * 18 + i));
            }
        }

        for (j = 0; j < 9; ++j) {
            this.addSlotToContainer(new Slot(playerInv, j, 8 + j * 18, 161 + i));
        }
    }

    @Override
    public boolean canInteractWith(EntityPlayer player)
    {
        return true;
    }

    public void writeToNBT(ItemStack stack)
    {
        if (!stack.hasTagCompound()) stack.setTagCompound(new NBTTagCompound());
        invBackpack.writeToNBT(stack.getTagCompound());
    }

    @Override
    public ItemStack transferStackInSlot(EntityPlayer player, int index)
    {
        ItemStack itemstack = null;
        Slot slot = (Slot) this.inventorySlots.get(index);

        if (slot != null && slot.getHasStack())
        {
            ItemStack itemstack1 = slot.getStack();
            itemstack = itemstack1.copy();

            if (itemstack.getItem() instanceof ItemBag)
            {
                return null;
            }

            if (index < this.invBackpack.getSizeInventory())
            {
                if (!this.mergeItemStack(itemstack1, this.invBackpack.getSizeInventory(), this.inventorySlots.size(), true))
                {
                    return null;
                }
            }
            else if (!this.mergeItemStack(itemstack1, 0, this.invBackpack.getSizeInventory(), false))
            {
                return null;
            }

            if (itemstack1.stackSize == 0)
            {
                slot.putStack((ItemStack) null);
            }
            else
            {
                slot.onSlotChanged();
            }
        }
        return itemstack;
    }

    @Override
    public void onContainerClosed(EntityPlayer player)
    {
        if (player.getHeldItem(EnumHand.MAIN_HAND).getItem() == SpyUtilItems.BAG)
        {
            this.writeToNBT(player.getHeldItem(EnumHand.MAIN_HAND));
        }
        else if (player.getHeldItem(EnumHand.OFF_HAND).getItem() == SpyUtilItems.BAG)
        {
            this.writeToNBT(player.getHeldItem(EnumHand.OFF_HAND));
        }
        super.onContainerClosed(player);
    }

    /**
     * When gui is opened, this item is immovable.
     */
    @Override
    public ItemStack slotClick(int slot, int dragType, ClickType clickType, EntityPlayer player)
    {
        if (slot >= 0 && getSlot(slot) != null && getSlot(slot).getStack() == player.getHeldItem(EnumHand.MAIN_HAND))
        {
            return null;
        }
        return super.slotClick(slot, dragType, clickType, player);
    }
}
